/*
* hal_hdmitx_top_tbl.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

//****************************************************
// Drive Chip           : CAMDRV_HDMITX
// Excel CodeGen Version: 1.05
// Excel SW      Version: 1.01
// Excel update date    : 2019/9/23 17:41
//****************************************************


#ifndef _HAL_HDMITX_TOP_TBL_H_
#define _HAL_HDMITX_TOP_TBL_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "mhal_common.h"

#define DRV_REG(reg)           ((reg>>16)&0xFF), ((reg>>8)&0xFF), (reg&0xFF)
#define REG_ADDR_SIZE          3
#define REG_MASK_SIZE          1
#define REG_DATA_SIZE          1
#define REG_TABLE_END          0xFFFFFF

#ifndef _PK_L_
#define _PK_L_(bank, addr)     ((MS_U16)(bank << 8) | ((addr)*2)) 
#endif
#ifndef _PK_H_
#define _PK_H_(bank, addr)     ((MS_U16)((bank|0x80) << 8) | ((addr)*2+1)) 
#endif

////////////////////////////////////////////////////////////////////////////////
#define HDMITX_ATOP_REG_NUM        15
#define HDMITX_ATOP_COMMON_REG_NUM        18
#define HDMITX_DTOP_TIMING_REG_NUM        13
#define HDMITX_DTOP_TIMING_COMMON_REG_NUM        7
#define HDMITX_DTOP_REG_NUM        1
#define HDMITX_DTOP_COMMON_REG_NUM        10
#define HDMITX_DTOP_CTRL_COMMON_REG_NUM        26
////////////////////////////////////////////////////////////////////////////////
#define  REG_HDMITX_ATOP_BASE     0x112600
#define  REG_HDMITX_DTOP_BASE     0x112500
#define  REG_DAC_ATOP_BASE     0x112700
#define  REG_DISP_TOP_BASE     0x112800
#define  REG_SC_GP_CTRL_BASE     0x113300
#define  REG_CLKGEN_BASE     0x103800

////////////////////////////////////////////////////////////////////////////////
typedef enum
{
    HAL_HDMITX_ID_480_60P=0x0,
    HAL_HDMITX_ID_576_50P=0x1,
    HAL_HDMITX_ID_720_50P=0x2,
    HAL_HDMITX_ID_720_60P=0x3,
    HAL_HDMITX_ID_1080_24P=0x4,
    HAL_HDMITX_ID_1080_25P=0x5,
    HAL_HDMITX_ID_1080_30P=0x6,
    HAL_HDMITX_ID_1080_50P=0x7,
    HAL_HDMITX_ID_1080_60P=0x8,
    HAL_HDMITX_ID_3840x2160_30P=0x9,
    HAL_HDMITX_ID_1024x768_60P=0xA,
    HAL_HDMITX_ID_1280x1024_60P=0xB,
    HAL_HDMITX_ID_1366x768_60P=0xC,
    HAL_HDMITX_ID_1440x900_60P=0xD,
    HAL_HDMITX_ID_1280x800_60P=0xE,
    HAL_HDMITX_ID_1680x1050_60P=0xF,
    HAL_HDMITX_ID_1600x1200_60P=0x10,
    HAL_HDMITX_ID_NUM=0x11,
} E_HAL_HDMITX_ID_TYPE;

typedef enum
{
    HAL_HDMITX_TAB_HDMITX_ATOP,
    HAL_HDMITX_COMMON_TAB_HDMITX_ATOP,
    HAL_HDMITX_TAB_HDMITX_DTOP_TIMING,
    HAL_HDMITX_COMMON_TAB_HDMITX_DTOP_TIMING,
    HAL_HDMITX_TAB_HDMITX_DTOP,
    HAL_HDMITX_COMMON_TAB_HDMITX_DTOP,
    HAL_HDMITX_TAB_NUM,
} E_HAL_HDMITX_TAB_TYPE;

typedef enum
{
    HAL_HDMITX_IP_NORMAL,
    HAL_HDMITX_IP_COMMON
} E_HAL_HDMITX_IP_TYPE;

typedef struct
{
    MS_U8                 *pData;
    MS_U16                 u16RegNum;
    E_HAL_HDMITX_IP_TYPE enIPType;
} HAL_HDMITX_INFO;

extern HAL_HDMITX_INFO stHAL_HDMITX_TOP_TBL[HAL_HDMITX_TAB_NUM];

//-------------------------------------------------------------------------------------------------
// register define used for TCON table
//-------------------------------------------------------------------------------------------------

#define  REG_HDMITX_ATOP_00_L       (REG_HDMITX_ATOP_BASE + 0x00)
#define  REG_HDMITX_ATOP_00_H       (REG_HDMITX_ATOP_BASE + 0x01)
#define  REG_HDMITX_ATOP_01_L       (REG_HDMITX_ATOP_BASE + 0x02)
#define  REG_HDMITX_ATOP_01_H       (REG_HDMITX_ATOP_BASE + 0x03)
#define  REG_HDMITX_ATOP_02_L       (REG_HDMITX_ATOP_BASE + 0x04)
#define  REG_HDMITX_ATOP_02_H       (REG_HDMITX_ATOP_BASE + 0x05)
#define  REG_HDMITX_ATOP_03_L       (REG_HDMITX_ATOP_BASE + 0x06)
#define  REG_HDMITX_ATOP_03_H       (REG_HDMITX_ATOP_BASE + 0x07)
#define  REG_HDMITX_ATOP_04_L       (REG_HDMITX_ATOP_BASE + 0x08)
#define  REG_HDMITX_ATOP_04_H       (REG_HDMITX_ATOP_BASE + 0x09)
#define  REG_HDMITX_ATOP_05_L       (REG_HDMITX_ATOP_BASE + 0x0A)
#define  REG_HDMITX_ATOP_05_H       (REG_HDMITX_ATOP_BASE + 0x0B)
#define  REG_HDMITX_ATOP_06_L       (REG_HDMITX_ATOP_BASE + 0x0C)
#define  REG_HDMITX_ATOP_06_H       (REG_HDMITX_ATOP_BASE + 0x0D)
#define  REG_HDMITX_ATOP_07_L       (REG_HDMITX_ATOP_BASE + 0x0E)
#define  REG_HDMITX_ATOP_07_H       (REG_HDMITX_ATOP_BASE + 0x0F)
#define  REG_HDMITX_ATOP_08_L       (REG_HDMITX_ATOP_BASE + 0x10)
#define  REG_HDMITX_ATOP_08_H       (REG_HDMITX_ATOP_BASE + 0x11)
#define  REG_HDMITX_ATOP_09_L       (REG_HDMITX_ATOP_BASE + 0x12)
#define  REG_HDMITX_ATOP_09_H       (REG_HDMITX_ATOP_BASE + 0x13)
#define  REG_HDMITX_ATOP_0A_L       (REG_HDMITX_ATOP_BASE + 0x14)
#define  REG_HDMITX_ATOP_0A_H       (REG_HDMITX_ATOP_BASE + 0x15)
#define  REG_HDMITX_ATOP_0B_L       (REG_HDMITX_ATOP_BASE + 0x16)
#define  REG_HDMITX_ATOP_0B_H       (REG_HDMITX_ATOP_BASE + 0x17)
#define  REG_HDMITX_ATOP_0C_L       (REG_HDMITX_ATOP_BASE + 0x18)
#define  REG_HDMITX_ATOP_0C_H       (REG_HDMITX_ATOP_BASE + 0x19)
#define  REG_HDMITX_ATOP_0D_L       (REG_HDMITX_ATOP_BASE + 0x1A)
#define  REG_HDMITX_ATOP_0D_H       (REG_HDMITX_ATOP_BASE + 0x1B)
#define  REG_HDMITX_ATOP_0E_L       (REG_HDMITX_ATOP_BASE + 0x1C)
#define  REG_HDMITX_ATOP_0E_H       (REG_HDMITX_ATOP_BASE + 0x1D)
#define  REG_HDMITX_ATOP_0F_L       (REG_HDMITX_ATOP_BASE + 0x1E)
#define  REG_HDMITX_ATOP_0F_H       (REG_HDMITX_ATOP_BASE + 0x1F)
#define  REG_HDMITX_ATOP_10_L       (REG_HDMITX_ATOP_BASE + 0x20)
#define  REG_HDMITX_ATOP_10_H       (REG_HDMITX_ATOP_BASE + 0x21)
#define  REG_HDMITX_ATOP_11_L       (REG_HDMITX_ATOP_BASE + 0x22)
#define  REG_HDMITX_ATOP_11_H       (REG_HDMITX_ATOP_BASE + 0x23)
#define  REG_HDMITX_ATOP_12_L       (REG_HDMITX_ATOP_BASE + 0x24)
#define  REG_HDMITX_ATOP_12_H       (REG_HDMITX_ATOP_BASE + 0x25)
#define  REG_HDMITX_ATOP_13_L       (REG_HDMITX_ATOP_BASE + 0x26)
#define  REG_HDMITX_ATOP_13_H       (REG_HDMITX_ATOP_BASE + 0x27)
#define  REG_HDMITX_ATOP_14_L       (REG_HDMITX_ATOP_BASE + 0x28)
#define  REG_HDMITX_ATOP_14_H       (REG_HDMITX_ATOP_BASE + 0x29)
#define  REG_HDMITX_ATOP_15_L       (REG_HDMITX_ATOP_BASE + 0x2A)
#define  REG_HDMITX_ATOP_15_H       (REG_HDMITX_ATOP_BASE + 0x2B)
#define  REG_HDMITX_ATOP_16_L       (REG_HDMITX_ATOP_BASE + 0x2C)
#define  REG_HDMITX_ATOP_16_H       (REG_HDMITX_ATOP_BASE + 0x2D)
#define  REG_HDMITX_ATOP_17_L       (REG_HDMITX_ATOP_BASE + 0x2E)
#define  REG_HDMITX_ATOP_17_H       (REG_HDMITX_ATOP_BASE + 0x2F)
#define  REG_HDMITX_ATOP_18_L       (REG_HDMITX_ATOP_BASE + 0x30)
#define  REG_HDMITX_ATOP_18_H       (REG_HDMITX_ATOP_BASE + 0x31)
#define  REG_HDMITX_ATOP_19_L       (REG_HDMITX_ATOP_BASE + 0x32)
#define  REG_HDMITX_ATOP_19_H       (REG_HDMITX_ATOP_BASE + 0x33)
#define  REG_HDMITX_ATOP_1A_L       (REG_HDMITX_ATOP_BASE + 0x34)
#define  REG_HDMITX_ATOP_1A_H       (REG_HDMITX_ATOP_BASE + 0x35)
#define  REG_HDMITX_ATOP_1B_L       (REG_HDMITX_ATOP_BASE + 0x36)
#define  REG_HDMITX_ATOP_1B_H       (REG_HDMITX_ATOP_BASE + 0x37)
#define  REG_HDMITX_ATOP_1C_L       (REG_HDMITX_ATOP_BASE + 0x38)
#define  REG_HDMITX_ATOP_1C_H       (REG_HDMITX_ATOP_BASE + 0x39)
#define  REG_HDMITX_ATOP_1D_L       (REG_HDMITX_ATOP_BASE + 0x3A)
#define  REG_HDMITX_ATOP_1D_H       (REG_HDMITX_ATOP_BASE + 0x3B)
#define  REG_HDMITX_ATOP_1E_L       (REG_HDMITX_ATOP_BASE + 0x3C)
#define  REG_HDMITX_ATOP_1E_H       (REG_HDMITX_ATOP_BASE + 0x3D)
#define  REG_HDMITX_ATOP_1F_L       (REG_HDMITX_ATOP_BASE + 0x3E)
#define  REG_HDMITX_ATOP_1F_H       (REG_HDMITX_ATOP_BASE + 0x3F)
#define  REG_HDMITX_ATOP_20_L       (REG_HDMITX_ATOP_BASE + 0x40)
#define  REG_HDMITX_ATOP_20_H       (REG_HDMITX_ATOP_BASE + 0x41)
#define  REG_HDMITX_ATOP_21_L       (REG_HDMITX_ATOP_BASE + 0x42)
#define  REG_HDMITX_ATOP_21_H       (REG_HDMITX_ATOP_BASE + 0x43)
#define  REG_HDMITX_ATOP_22_L       (REG_HDMITX_ATOP_BASE + 0x44)
#define  REG_HDMITX_ATOP_22_H       (REG_HDMITX_ATOP_BASE + 0x45)
#define  REG_HDMITX_ATOP_23_L       (REG_HDMITX_ATOP_BASE + 0x46)
#define  REG_HDMITX_ATOP_23_H       (REG_HDMITX_ATOP_BASE + 0x47)
#define  REG_HDMITX_ATOP_24_L       (REG_HDMITX_ATOP_BASE + 0x48)
#define  REG_HDMITX_ATOP_24_H       (REG_HDMITX_ATOP_BASE + 0x49)
#define  REG_HDMITX_ATOP_25_L       (REG_HDMITX_ATOP_BASE + 0x4A)
#define  REG_HDMITX_ATOP_25_H       (REG_HDMITX_ATOP_BASE + 0x4B)
#define  REG_HDMITX_ATOP_26_L       (REG_HDMITX_ATOP_BASE + 0x4C)
#define  REG_HDMITX_ATOP_26_H       (REG_HDMITX_ATOP_BASE + 0x4D)
#define  REG_HDMITX_ATOP_27_L       (REG_HDMITX_ATOP_BASE + 0x4E)
#define  REG_HDMITX_ATOP_27_H       (REG_HDMITX_ATOP_BASE + 0x4F)
#define  REG_HDMITX_ATOP_28_L       (REG_HDMITX_ATOP_BASE + 0x50)
#define  REG_HDMITX_ATOP_28_H       (REG_HDMITX_ATOP_BASE + 0x51)
#define  REG_HDMITX_ATOP_29_L       (REG_HDMITX_ATOP_BASE + 0x52)
#define  REG_HDMITX_ATOP_29_H       (REG_HDMITX_ATOP_BASE + 0x53)
#define  REG_HDMITX_ATOP_2A_L       (REG_HDMITX_ATOP_BASE + 0x54)
#define  REG_HDMITX_ATOP_2A_H       (REG_HDMITX_ATOP_BASE + 0x55)
#define  REG_HDMITX_ATOP_2B_L       (REG_HDMITX_ATOP_BASE + 0x56)
#define  REG_HDMITX_ATOP_2B_H       (REG_HDMITX_ATOP_BASE + 0x57)
#define  REG_HDMITX_ATOP_2C_L       (REG_HDMITX_ATOP_BASE + 0x58)
#define  REG_HDMITX_ATOP_2C_H       (REG_HDMITX_ATOP_BASE + 0x59)
#define  REG_HDMITX_ATOP_2D_L       (REG_HDMITX_ATOP_BASE + 0x5A)
#define  REG_HDMITX_ATOP_2D_H       (REG_HDMITX_ATOP_BASE + 0x5B)
#define  REG_HDMITX_ATOP_2E_L       (REG_HDMITX_ATOP_BASE + 0x5C)
#define  REG_HDMITX_ATOP_2E_H       (REG_HDMITX_ATOP_BASE + 0x5D)
#define  REG_HDMITX_ATOP_2F_L       (REG_HDMITX_ATOP_BASE + 0x5E)
#define  REG_HDMITX_ATOP_2F_H       (REG_HDMITX_ATOP_BASE + 0x5F)
#define  REG_HDMITX_ATOP_30_L       (REG_HDMITX_ATOP_BASE + 0x60)
#define  REG_HDMITX_ATOP_30_H       (REG_HDMITX_ATOP_BASE + 0x61)
#define  REG_HDMITX_ATOP_31_L       (REG_HDMITX_ATOP_BASE + 0x62)
#define  REG_HDMITX_ATOP_31_H       (REG_HDMITX_ATOP_BASE + 0x63)
#define  REG_HDMITX_ATOP_32_L       (REG_HDMITX_ATOP_BASE + 0x64)
#define  REG_HDMITX_ATOP_32_H       (REG_HDMITX_ATOP_BASE + 0x65)
#define  REG_HDMITX_ATOP_33_L       (REG_HDMITX_ATOP_BASE + 0x66)
#define  REG_HDMITX_ATOP_33_H       (REG_HDMITX_ATOP_BASE + 0x67)
#define  REG_HDMITX_ATOP_34_L       (REG_HDMITX_ATOP_BASE + 0x68)
#define  REG_HDMITX_ATOP_34_H       (REG_HDMITX_ATOP_BASE + 0x69)
#define  REG_HDMITX_ATOP_35_L       (REG_HDMITX_ATOP_BASE + 0x6A)
#define  REG_HDMITX_ATOP_35_H       (REG_HDMITX_ATOP_BASE + 0x6B)
#define  REG_HDMITX_ATOP_36_L       (REG_HDMITX_ATOP_BASE + 0x6C)
#define  REG_HDMITX_ATOP_36_H       (REG_HDMITX_ATOP_BASE + 0x6D)
#define  REG_HDMITX_ATOP_37_L       (REG_HDMITX_ATOP_BASE + 0x6E)
#define  REG_HDMITX_ATOP_37_H       (REG_HDMITX_ATOP_BASE + 0x6F)
#define  REG_HDMITX_ATOP_38_L       (REG_HDMITX_ATOP_BASE + 0x70)
#define  REG_HDMITX_ATOP_38_H       (REG_HDMITX_ATOP_BASE + 0x71)
#define  REG_HDMITX_ATOP_39_L       (REG_HDMITX_ATOP_BASE + 0x72)
#define  REG_HDMITX_ATOP_39_H       (REG_HDMITX_ATOP_BASE + 0x73)
#define  REG_HDMITX_ATOP_3A_L       (REG_HDMITX_ATOP_BASE + 0x74)
#define  REG_HDMITX_ATOP_3A_H       (REG_HDMITX_ATOP_BASE + 0x75)
#define  REG_HDMITX_ATOP_3B_L       (REG_HDMITX_ATOP_BASE + 0x76)
#define  REG_HDMITX_ATOP_3B_H       (REG_HDMITX_ATOP_BASE + 0x77)
#define  REG_HDMITX_ATOP_3C_L       (REG_HDMITX_ATOP_BASE + 0x78)
#define  REG_HDMITX_ATOP_3C_H       (REG_HDMITX_ATOP_BASE + 0x79)
#define  REG_HDMITX_ATOP_3D_L       (REG_HDMITX_ATOP_BASE + 0x7A)
#define  REG_HDMITX_ATOP_3D_H       (REG_HDMITX_ATOP_BASE + 0x7B)
#define  REG_HDMITX_ATOP_3E_L       (REG_HDMITX_ATOP_BASE + 0x7C)
#define  REG_HDMITX_ATOP_3E_H       (REG_HDMITX_ATOP_BASE + 0x7D)
#define  REG_HDMITX_ATOP_3F_L       (REG_HDMITX_ATOP_BASE + 0x7E)
#define  REG_HDMITX_ATOP_3F_H       (REG_HDMITX_ATOP_BASE + 0x7F)
#define  REG_HDMITX_ATOP_40_L       (REG_HDMITX_ATOP_BASE + 0x80)
#define  REG_HDMITX_ATOP_40_H       (REG_HDMITX_ATOP_BASE + 0x81)
#define  REG_HDMITX_ATOP_41_L       (REG_HDMITX_ATOP_BASE + 0x82)
#define  REG_HDMITX_ATOP_41_H       (REG_HDMITX_ATOP_BASE + 0x83)
#define  REG_HDMITX_ATOP_42_L       (REG_HDMITX_ATOP_BASE + 0x84)
#define  REG_HDMITX_ATOP_42_H       (REG_HDMITX_ATOP_BASE + 0x85)
#define  REG_HDMITX_ATOP_43_L       (REG_HDMITX_ATOP_BASE + 0x86)
#define  REG_HDMITX_ATOP_43_H       (REG_HDMITX_ATOP_BASE + 0x87)
#define  REG_HDMITX_ATOP_44_L       (REG_HDMITX_ATOP_BASE + 0x88)
#define  REG_HDMITX_ATOP_44_H       (REG_HDMITX_ATOP_BASE + 0x89)
#define  REG_HDMITX_ATOP_45_L       (REG_HDMITX_ATOP_BASE + 0x8A)
#define  REG_HDMITX_ATOP_45_H       (REG_HDMITX_ATOP_BASE + 0x8B)
#define  REG_HDMITX_ATOP_46_L       (REG_HDMITX_ATOP_BASE + 0x8C)
#define  REG_HDMITX_ATOP_46_H       (REG_HDMITX_ATOP_BASE + 0x8D)
#define  REG_HDMITX_ATOP_47_L       (REG_HDMITX_ATOP_BASE + 0x8E)
#define  REG_HDMITX_ATOP_47_H       (REG_HDMITX_ATOP_BASE + 0x8F)
#define  REG_HDMITX_ATOP_48_L       (REG_HDMITX_ATOP_BASE + 0x90)
#define  REG_HDMITX_ATOP_48_H       (REG_HDMITX_ATOP_BASE + 0x91)
#define  REG_HDMITX_ATOP_49_L       (REG_HDMITX_ATOP_BASE + 0x92)
#define  REG_HDMITX_ATOP_49_H       (REG_HDMITX_ATOP_BASE + 0x93)
#define  REG_HDMITX_ATOP_4A_L       (REG_HDMITX_ATOP_BASE + 0x94)
#define  REG_HDMITX_ATOP_4A_H       (REG_HDMITX_ATOP_BASE + 0x95)
#define  REG_HDMITX_ATOP_4B_L       (REG_HDMITX_ATOP_BASE + 0x96)
#define  REG_HDMITX_ATOP_4B_H       (REG_HDMITX_ATOP_BASE + 0x97)
#define  REG_HDMITX_ATOP_4C_L       (REG_HDMITX_ATOP_BASE + 0x98)
#define  REG_HDMITX_ATOP_4C_H       (REG_HDMITX_ATOP_BASE + 0x99)
#define  REG_HDMITX_ATOP_4D_L       (REG_HDMITX_ATOP_BASE + 0x9A)
#define  REG_HDMITX_ATOP_4D_H       (REG_HDMITX_ATOP_BASE + 0x9B)
#define  REG_HDMITX_ATOP_4E_L       (REG_HDMITX_ATOP_BASE + 0x9C)
#define  REG_HDMITX_ATOP_4E_H       (REG_HDMITX_ATOP_BASE + 0x9D)
#define  REG_HDMITX_ATOP_4F_L       (REG_HDMITX_ATOP_BASE + 0x9E)
#define  REG_HDMITX_ATOP_4F_H       (REG_HDMITX_ATOP_BASE + 0x9F)
#define  REG_HDMITX_ATOP_50_L       (REG_HDMITX_ATOP_BASE + 0xA0)
#define  REG_HDMITX_ATOP_50_H       (REG_HDMITX_ATOP_BASE + 0xA1)
#define  REG_HDMITX_ATOP_51_L       (REG_HDMITX_ATOP_BASE + 0xA2)
#define  REG_HDMITX_ATOP_51_H       (REG_HDMITX_ATOP_BASE + 0xA3)
#define  REG_HDMITX_ATOP_52_L       (REG_HDMITX_ATOP_BASE + 0xA4)
#define  REG_HDMITX_ATOP_52_H       (REG_HDMITX_ATOP_BASE + 0xA5)
#define  REG_HDMITX_ATOP_53_L       (REG_HDMITX_ATOP_BASE + 0xA6)
#define  REG_HDMITX_ATOP_53_H       (REG_HDMITX_ATOP_BASE + 0xA7)
#define  REG_HDMITX_ATOP_54_L       (REG_HDMITX_ATOP_BASE + 0xA8)
#define  REG_HDMITX_ATOP_54_H       (REG_HDMITX_ATOP_BASE + 0xA9)
#define  REG_HDMITX_ATOP_55_L       (REG_HDMITX_ATOP_BASE + 0xAA)
#define  REG_HDMITX_ATOP_55_H       (REG_HDMITX_ATOP_BASE + 0xAB)
#define  REG_HDMITX_ATOP_56_L       (REG_HDMITX_ATOP_BASE + 0xAC)
#define  REG_HDMITX_ATOP_56_H       (REG_HDMITX_ATOP_BASE + 0xAD)
#define  REG_HDMITX_ATOP_57_L       (REG_HDMITX_ATOP_BASE + 0xAE)
#define  REG_HDMITX_ATOP_57_H       (REG_HDMITX_ATOP_BASE + 0xAF)
#define  REG_HDMITX_ATOP_58_L       (REG_HDMITX_ATOP_BASE + 0xB0)
#define  REG_HDMITX_ATOP_58_H       (REG_HDMITX_ATOP_BASE + 0xB1)
#define  REG_HDMITX_ATOP_59_L       (REG_HDMITX_ATOP_BASE + 0xB2)
#define  REG_HDMITX_ATOP_59_H       (REG_HDMITX_ATOP_BASE + 0xB3)
#define  REG_HDMITX_ATOP_5A_L       (REG_HDMITX_ATOP_BASE + 0xB4)
#define  REG_HDMITX_ATOP_5A_H       (REG_HDMITX_ATOP_BASE + 0xB5)
#define  REG_HDMITX_ATOP_5B_L       (REG_HDMITX_ATOP_BASE + 0xB6)
#define  REG_HDMITX_ATOP_5B_H       (REG_HDMITX_ATOP_BASE + 0xB7)
#define  REG_HDMITX_ATOP_5C_L       (REG_HDMITX_ATOP_BASE + 0xB8)
#define  REG_HDMITX_ATOP_5C_H       (REG_HDMITX_ATOP_BASE + 0xB9)
#define  REG_HDMITX_ATOP_5D_L       (REG_HDMITX_ATOP_BASE + 0xBA)
#define  REG_HDMITX_ATOP_5D_H       (REG_HDMITX_ATOP_BASE + 0xBB)
#define  REG_HDMITX_ATOP_5E_L       (REG_HDMITX_ATOP_BASE + 0xBC)
#define  REG_HDMITX_ATOP_5E_H       (REG_HDMITX_ATOP_BASE + 0xBD)
#define  REG_HDMITX_ATOP_5F_L       (REG_HDMITX_ATOP_BASE + 0xBE)
#define  REG_HDMITX_ATOP_5F_H       (REG_HDMITX_ATOP_BASE + 0xBF)
#define  REG_HDMITX_ATOP_60_L       (REG_HDMITX_ATOP_BASE + 0xC0)
#define  REG_HDMITX_ATOP_60_H       (REG_HDMITX_ATOP_BASE + 0xC1)
#define  REG_HDMITX_ATOP_61_L       (REG_HDMITX_ATOP_BASE + 0xC2)
#define  REG_HDMITX_ATOP_61_H       (REG_HDMITX_ATOP_BASE + 0xC3)
#define  REG_HDMITX_ATOP_62_L       (REG_HDMITX_ATOP_BASE + 0xC4)
#define  REG_HDMITX_ATOP_62_H       (REG_HDMITX_ATOP_BASE + 0xC5)
#define  REG_HDMITX_ATOP_63_L       (REG_HDMITX_ATOP_BASE + 0xC6)
#define  REG_HDMITX_ATOP_63_H       (REG_HDMITX_ATOP_BASE + 0xC7)
#define  REG_HDMITX_ATOP_64_L       (REG_HDMITX_ATOP_BASE + 0xC8)
#define  REG_HDMITX_ATOP_64_H       (REG_HDMITX_ATOP_BASE + 0xC9)
#define  REG_HDMITX_ATOP_65_L       (REG_HDMITX_ATOP_BASE + 0xCA)
#define  REG_HDMITX_ATOP_65_H       (REG_HDMITX_ATOP_BASE + 0xCB)
#define  REG_HDMITX_ATOP_66_L       (REG_HDMITX_ATOP_BASE + 0xCC)
#define  REG_HDMITX_ATOP_66_H       (REG_HDMITX_ATOP_BASE + 0xCD)
#define  REG_HDMITX_ATOP_67_L       (REG_HDMITX_ATOP_BASE + 0xCE)
#define  REG_HDMITX_ATOP_67_H       (REG_HDMITX_ATOP_BASE + 0xCF)
#define  REG_HDMITX_ATOP_68_L       (REG_HDMITX_ATOP_BASE + 0xD0)
#define  REG_HDMITX_ATOP_68_H       (REG_HDMITX_ATOP_BASE + 0xD1)
#define  REG_HDMITX_ATOP_69_L       (REG_HDMITX_ATOP_BASE + 0xD2)
#define  REG_HDMITX_ATOP_69_H       (REG_HDMITX_ATOP_BASE + 0xD3)
#define  REG_HDMITX_ATOP_6A_L       (REG_HDMITX_ATOP_BASE + 0xD4)
#define  REG_HDMITX_ATOP_6A_H       (REG_HDMITX_ATOP_BASE + 0xD5)
#define  REG_HDMITX_ATOP_6B_L       (REG_HDMITX_ATOP_BASE + 0xD6)
#define  REG_HDMITX_ATOP_6B_H       (REG_HDMITX_ATOP_BASE + 0xD7)
#define  REG_HDMITX_ATOP_6C_L       (REG_HDMITX_ATOP_BASE + 0xD8)
#define  REG_HDMITX_ATOP_6C_H       (REG_HDMITX_ATOP_BASE + 0xD9)
#define  REG_HDMITX_ATOP_6D_L       (REG_HDMITX_ATOP_BASE + 0xDA)
#define  REG_HDMITX_ATOP_6D_H       (REG_HDMITX_ATOP_BASE + 0xDB)
#define  REG_HDMITX_ATOP_6E_L       (REG_HDMITX_ATOP_BASE + 0xDC)
#define  REG_HDMITX_ATOP_6E_H       (REG_HDMITX_ATOP_BASE + 0xDD)
#define  REG_HDMITX_ATOP_6F_L       (REG_HDMITX_ATOP_BASE + 0xDE)
#define  REG_HDMITX_ATOP_6F_H       (REG_HDMITX_ATOP_BASE + 0xDF)
#define  REG_HDMITX_ATOP_70_L       (REG_HDMITX_ATOP_BASE + 0xE0)
#define  REG_HDMITX_ATOP_70_H       (REG_HDMITX_ATOP_BASE + 0xE1)
#define  REG_HDMITX_ATOP_71_L       (REG_HDMITX_ATOP_BASE + 0xE2)
#define  REG_HDMITX_ATOP_71_H       (REG_HDMITX_ATOP_BASE + 0xE3)
#define  REG_HDMITX_ATOP_72_L       (REG_HDMITX_ATOP_BASE + 0xE4)
#define  REG_HDMITX_ATOP_72_H       (REG_HDMITX_ATOP_BASE + 0xE5)
#define  REG_HDMITX_ATOP_73_L       (REG_HDMITX_ATOP_BASE + 0xE6)
#define  REG_HDMITX_ATOP_73_H       (REG_HDMITX_ATOP_BASE + 0xE7)
#define  REG_HDMITX_ATOP_74_L       (REG_HDMITX_ATOP_BASE + 0xE8)
#define  REG_HDMITX_ATOP_74_H       (REG_HDMITX_ATOP_BASE + 0xE9)
#define  REG_HDMITX_ATOP_75_L       (REG_HDMITX_ATOP_BASE + 0xEA)
#define  REG_HDMITX_ATOP_75_H       (REG_HDMITX_ATOP_BASE + 0xEB)
#define  REG_HDMITX_ATOP_76_L       (REG_HDMITX_ATOP_BASE + 0xEC)
#define  REG_HDMITX_ATOP_76_H       (REG_HDMITX_ATOP_BASE + 0xED)
#define  REG_HDMITX_ATOP_77_L       (REG_HDMITX_ATOP_BASE + 0xEE)
#define  REG_HDMITX_ATOP_77_H       (REG_HDMITX_ATOP_BASE + 0xEF)
#define  REG_HDMITX_ATOP_78_L       (REG_HDMITX_ATOP_BASE + 0xF0)
#define  REG_HDMITX_ATOP_78_H       (REG_HDMITX_ATOP_BASE + 0xF1)
#define  REG_HDMITX_ATOP_79_L       (REG_HDMITX_ATOP_BASE + 0xF2)
#define  REG_HDMITX_ATOP_79_H       (REG_HDMITX_ATOP_BASE + 0xF3)
#define  REG_HDMITX_ATOP_7A_L       (REG_HDMITX_ATOP_BASE + 0xF4)
#define  REG_HDMITX_ATOP_7A_H       (REG_HDMITX_ATOP_BASE + 0xF5)
#define  REG_HDMITX_ATOP_7B_L       (REG_HDMITX_ATOP_BASE + 0xF6)
#define  REG_HDMITX_ATOP_7B_H       (REG_HDMITX_ATOP_BASE + 0xF7)
#define  REG_HDMITX_ATOP_7C_L       (REG_HDMITX_ATOP_BASE + 0xF8)
#define  REG_HDMITX_ATOP_7C_H       (REG_HDMITX_ATOP_BASE + 0xF9)
#define  REG_HDMITX_ATOP_7D_L       (REG_HDMITX_ATOP_BASE + 0xFA)
#define  REG_HDMITX_ATOP_7D_H       (REG_HDMITX_ATOP_BASE + 0xFB)
#define  REG_HDMITX_ATOP_7E_L       (REG_HDMITX_ATOP_BASE + 0xFC)
#define  REG_HDMITX_ATOP_7E_H       (REG_HDMITX_ATOP_BASE + 0xFD)
#define  REG_HDMITX_ATOP_7F_L       (REG_HDMITX_ATOP_BASE + 0xFE)
#define  REG_HDMITX_ATOP_7F_H       (REG_HDMITX_ATOP_BASE + 0xFF)

#define  REG_HDMITX_DTOP_00_L       (REG_HDMITX_DTOP_BASE + 0x00)
#define  REG_HDMITX_DTOP_00_H       (REG_HDMITX_DTOP_BASE + 0x01)
#define  REG_HDMITX_DTOP_01_L       (REG_HDMITX_DTOP_BASE + 0x02)
#define  REG_HDMITX_DTOP_01_H       (REG_HDMITX_DTOP_BASE + 0x03)
#define  REG_HDMITX_DTOP_02_L       (REG_HDMITX_DTOP_BASE + 0x04)
#define  REG_HDMITX_DTOP_02_H       (REG_HDMITX_DTOP_BASE + 0x05)
#define  REG_HDMITX_DTOP_03_L       (REG_HDMITX_DTOP_BASE + 0x06)
#define  REG_HDMITX_DTOP_03_H       (REG_HDMITX_DTOP_BASE + 0x07)
#define  REG_HDMITX_DTOP_04_L       (REG_HDMITX_DTOP_BASE + 0x08)
#define  REG_HDMITX_DTOP_04_H       (REG_HDMITX_DTOP_BASE + 0x09)
#define  REG_HDMITX_DTOP_05_L       (REG_HDMITX_DTOP_BASE + 0x0A)
#define  REG_HDMITX_DTOP_05_H       (REG_HDMITX_DTOP_BASE + 0x0B)
#define  REG_HDMITX_DTOP_06_L       (REG_HDMITX_DTOP_BASE + 0x0C)
#define  REG_HDMITX_DTOP_06_H       (REG_HDMITX_DTOP_BASE + 0x0D)
#define  REG_HDMITX_DTOP_07_L       (REG_HDMITX_DTOP_BASE + 0x0E)
#define  REG_HDMITX_DTOP_07_H       (REG_HDMITX_DTOP_BASE + 0x0F)
#define  REG_HDMITX_DTOP_08_L       (REG_HDMITX_DTOP_BASE + 0x10)
#define  REG_HDMITX_DTOP_08_H       (REG_HDMITX_DTOP_BASE + 0x11)
#define  REG_HDMITX_DTOP_09_L       (REG_HDMITX_DTOP_BASE + 0x12)
#define  REG_HDMITX_DTOP_09_H       (REG_HDMITX_DTOP_BASE + 0x13)
#define  REG_HDMITX_DTOP_0A_L       (REG_HDMITX_DTOP_BASE + 0x14)
#define  REG_HDMITX_DTOP_0A_H       (REG_HDMITX_DTOP_BASE + 0x15)
#define  REG_HDMITX_DTOP_0B_L       (REG_HDMITX_DTOP_BASE + 0x16)
#define  REG_HDMITX_DTOP_0B_H       (REG_HDMITX_DTOP_BASE + 0x17)
#define  REG_HDMITX_DTOP_0C_L       (REG_HDMITX_DTOP_BASE + 0x18)
#define  REG_HDMITX_DTOP_0C_H       (REG_HDMITX_DTOP_BASE + 0x19)
#define  REG_HDMITX_DTOP_0D_L       (REG_HDMITX_DTOP_BASE + 0x1A)
#define  REG_HDMITX_DTOP_0D_H       (REG_HDMITX_DTOP_BASE + 0x1B)
#define  REG_HDMITX_DTOP_0E_L       (REG_HDMITX_DTOP_BASE + 0x1C)
#define  REG_HDMITX_DTOP_0E_H       (REG_HDMITX_DTOP_BASE + 0x1D)
#define  REG_HDMITX_DTOP_0F_L       (REG_HDMITX_DTOP_BASE + 0x1E)
#define  REG_HDMITX_DTOP_0F_H       (REG_HDMITX_DTOP_BASE + 0x1F)
#define  REG_HDMITX_DTOP_10_L       (REG_HDMITX_DTOP_BASE + 0x20)
#define  REG_HDMITX_DTOP_10_H       (REG_HDMITX_DTOP_BASE + 0x21)
#define  REG_HDMITX_DTOP_11_L       (REG_HDMITX_DTOP_BASE + 0x22)
#define  REG_HDMITX_DTOP_11_H       (REG_HDMITX_DTOP_BASE + 0x23)
#define  REG_HDMITX_DTOP_12_L       (REG_HDMITX_DTOP_BASE + 0x24)
#define  REG_HDMITX_DTOP_12_H       (REG_HDMITX_DTOP_BASE + 0x25)
#define  REG_HDMITX_DTOP_13_L       (REG_HDMITX_DTOP_BASE + 0x26)
#define  REG_HDMITX_DTOP_13_H       (REG_HDMITX_DTOP_BASE + 0x27)
#define  REG_HDMITX_DTOP_14_L       (REG_HDMITX_DTOP_BASE + 0x28)
#define  REG_HDMITX_DTOP_14_H       (REG_HDMITX_DTOP_BASE + 0x29)
#define  REG_HDMITX_DTOP_15_L       (REG_HDMITX_DTOP_BASE + 0x2A)
#define  REG_HDMITX_DTOP_15_H       (REG_HDMITX_DTOP_BASE + 0x2B)
#define  REG_HDMITX_DTOP_16_L       (REG_HDMITX_DTOP_BASE + 0x2C)
#define  REG_HDMITX_DTOP_16_H       (REG_HDMITX_DTOP_BASE + 0x2D)
#define  REG_HDMITX_DTOP_17_L       (REG_HDMITX_DTOP_BASE + 0x2E)
#define  REG_HDMITX_DTOP_17_H       (REG_HDMITX_DTOP_BASE + 0x2F)
#define  REG_HDMITX_DTOP_18_L       (REG_HDMITX_DTOP_BASE + 0x30)
#define  REG_HDMITX_DTOP_18_H       (REG_HDMITX_DTOP_BASE + 0x31)
#define  REG_HDMITX_DTOP_19_L       (REG_HDMITX_DTOP_BASE + 0x32)
#define  REG_HDMITX_DTOP_19_H       (REG_HDMITX_DTOP_BASE + 0x33)
#define  REG_HDMITX_DTOP_1A_L       (REG_HDMITX_DTOP_BASE + 0x34)
#define  REG_HDMITX_DTOP_1A_H       (REG_HDMITX_DTOP_BASE + 0x35)
#define  REG_HDMITX_DTOP_1B_L       (REG_HDMITX_DTOP_BASE + 0x36)
#define  REG_HDMITX_DTOP_1B_H       (REG_HDMITX_DTOP_BASE + 0x37)
#define  REG_HDMITX_DTOP_1C_L       (REG_HDMITX_DTOP_BASE + 0x38)
#define  REG_HDMITX_DTOP_1C_H       (REG_HDMITX_DTOP_BASE + 0x39)
#define  REG_HDMITX_DTOP_1D_L       (REG_HDMITX_DTOP_BASE + 0x3A)
#define  REG_HDMITX_DTOP_1D_H       (REG_HDMITX_DTOP_BASE + 0x3B)
#define  REG_HDMITX_DTOP_1E_L       (REG_HDMITX_DTOP_BASE + 0x3C)
#define  REG_HDMITX_DTOP_1E_H       (REG_HDMITX_DTOP_BASE + 0x3D)
#define  REG_HDMITX_DTOP_1F_L       (REG_HDMITX_DTOP_BASE + 0x3E)
#define  REG_HDMITX_DTOP_1F_H       (REG_HDMITX_DTOP_BASE + 0x3F)
#define  REG_HDMITX_DTOP_20_L       (REG_HDMITX_DTOP_BASE + 0x40)
#define  REG_HDMITX_DTOP_20_H       (REG_HDMITX_DTOP_BASE + 0x41)
#define  REG_HDMITX_DTOP_21_L       (REG_HDMITX_DTOP_BASE + 0x42)
#define  REG_HDMITX_DTOP_21_H       (REG_HDMITX_DTOP_BASE + 0x43)
#define  REG_HDMITX_DTOP_22_L       (REG_HDMITX_DTOP_BASE + 0x44)
#define  REG_HDMITX_DTOP_22_H       (REG_HDMITX_DTOP_BASE + 0x45)
#define  REG_HDMITX_DTOP_23_L       (REG_HDMITX_DTOP_BASE + 0x46)
#define  REG_HDMITX_DTOP_23_H       (REG_HDMITX_DTOP_BASE + 0x47)
#define  REG_HDMITX_DTOP_24_L       (REG_HDMITX_DTOP_BASE + 0x48)
#define  REG_HDMITX_DTOP_24_H       (REG_HDMITX_DTOP_BASE + 0x49)
#define  REG_HDMITX_DTOP_25_L       (REG_HDMITX_DTOP_BASE + 0x4A)
#define  REG_HDMITX_DTOP_25_H       (REG_HDMITX_DTOP_BASE + 0x4B)
#define  REG_HDMITX_DTOP_26_L       (REG_HDMITX_DTOP_BASE + 0x4C)
#define  REG_HDMITX_DTOP_26_H       (REG_HDMITX_DTOP_BASE + 0x4D)
#define  REG_HDMITX_DTOP_27_L       (REG_HDMITX_DTOP_BASE + 0x4E)
#define  REG_HDMITX_DTOP_27_H       (REG_HDMITX_DTOP_BASE + 0x4F)
#define  REG_HDMITX_DTOP_28_L       (REG_HDMITX_DTOP_BASE + 0x50)
#define  REG_HDMITX_DTOP_28_H       (REG_HDMITX_DTOP_BASE + 0x51)
#define  REG_HDMITX_DTOP_29_L       (REG_HDMITX_DTOP_BASE + 0x52)
#define  REG_HDMITX_DTOP_29_H       (REG_HDMITX_DTOP_BASE + 0x53)
#define  REG_HDMITX_DTOP_2A_L       (REG_HDMITX_DTOP_BASE + 0x54)
#define  REG_HDMITX_DTOP_2A_H       (REG_HDMITX_DTOP_BASE + 0x55)
#define  REG_HDMITX_DTOP_2B_L       (REG_HDMITX_DTOP_BASE + 0x56)
#define  REG_HDMITX_DTOP_2B_H       (REG_HDMITX_DTOP_BASE + 0x57)
#define  REG_HDMITX_DTOP_2C_L       (REG_HDMITX_DTOP_BASE + 0x58)
#define  REG_HDMITX_DTOP_2C_H       (REG_HDMITX_DTOP_BASE + 0x59)
#define  REG_HDMITX_DTOP_2D_L       (REG_HDMITX_DTOP_BASE + 0x5A)
#define  REG_HDMITX_DTOP_2D_H       (REG_HDMITX_DTOP_BASE + 0x5B)
#define  REG_HDMITX_DTOP_2E_L       (REG_HDMITX_DTOP_BASE + 0x5C)
#define  REG_HDMITX_DTOP_2E_H       (REG_HDMITX_DTOP_BASE + 0x5D)
#define  REG_HDMITX_DTOP_2F_L       (REG_HDMITX_DTOP_BASE + 0x5E)
#define  REG_HDMITX_DTOP_2F_H       (REG_HDMITX_DTOP_BASE + 0x5F)
#define  REG_HDMITX_DTOP_30_L       (REG_HDMITX_DTOP_BASE + 0x60)
#define  REG_HDMITX_DTOP_30_H       (REG_HDMITX_DTOP_BASE + 0x61)
#define  REG_HDMITX_DTOP_31_L       (REG_HDMITX_DTOP_BASE + 0x62)
#define  REG_HDMITX_DTOP_31_H       (REG_HDMITX_DTOP_BASE + 0x63)
#define  REG_HDMITX_DTOP_32_L       (REG_HDMITX_DTOP_BASE + 0x64)
#define  REG_HDMITX_DTOP_32_H       (REG_HDMITX_DTOP_BASE + 0x65)
#define  REG_HDMITX_DTOP_33_L       (REG_HDMITX_DTOP_BASE + 0x66)
#define  REG_HDMITX_DTOP_33_H       (REG_HDMITX_DTOP_BASE + 0x67)
#define  REG_HDMITX_DTOP_34_L       (REG_HDMITX_DTOP_BASE + 0x68)
#define  REG_HDMITX_DTOP_34_H       (REG_HDMITX_DTOP_BASE + 0x69)
#define  REG_HDMITX_DTOP_35_L       (REG_HDMITX_DTOP_BASE + 0x6A)
#define  REG_HDMITX_DTOP_35_H       (REG_HDMITX_DTOP_BASE + 0x6B)
#define  REG_HDMITX_DTOP_36_L       (REG_HDMITX_DTOP_BASE + 0x6C)
#define  REG_HDMITX_DTOP_36_H       (REG_HDMITX_DTOP_BASE + 0x6D)
#define  REG_HDMITX_DTOP_37_L       (REG_HDMITX_DTOP_BASE + 0x6E)
#define  REG_HDMITX_DTOP_37_H       (REG_HDMITX_DTOP_BASE + 0x6F)
#define  REG_HDMITX_DTOP_38_L       (REG_HDMITX_DTOP_BASE + 0x70)
#define  REG_HDMITX_DTOP_38_H       (REG_HDMITX_DTOP_BASE + 0x71)
#define  REG_HDMITX_DTOP_39_L       (REG_HDMITX_DTOP_BASE + 0x72)
#define  REG_HDMITX_DTOP_39_H       (REG_HDMITX_DTOP_BASE + 0x73)
#define  REG_HDMITX_DTOP_3A_L       (REG_HDMITX_DTOP_BASE + 0x74)
#define  REG_HDMITX_DTOP_3A_H       (REG_HDMITX_DTOP_BASE + 0x75)
#define  REG_HDMITX_DTOP_3B_L       (REG_HDMITX_DTOP_BASE + 0x76)
#define  REG_HDMITX_DTOP_3B_H       (REG_HDMITX_DTOP_BASE + 0x77)
#define  REG_HDMITX_DTOP_3C_L       (REG_HDMITX_DTOP_BASE + 0x78)
#define  REG_HDMITX_DTOP_3C_H       (REG_HDMITX_DTOP_BASE + 0x79)
#define  REG_HDMITX_DTOP_3D_L       (REG_HDMITX_DTOP_BASE + 0x7A)
#define  REG_HDMITX_DTOP_3D_H       (REG_HDMITX_DTOP_BASE + 0x7B)
#define  REG_HDMITX_DTOP_3E_L       (REG_HDMITX_DTOP_BASE + 0x7C)
#define  REG_HDMITX_DTOP_3E_H       (REG_HDMITX_DTOP_BASE + 0x7D)
#define  REG_HDMITX_DTOP_3F_L       (REG_HDMITX_DTOP_BASE + 0x7E)
#define  REG_HDMITX_DTOP_3F_H       (REG_HDMITX_DTOP_BASE + 0x7F)
#define  REG_HDMITX_DTOP_40_L       (REG_HDMITX_DTOP_BASE + 0x80)
#define  REG_HDMITX_DTOP_40_H       (REG_HDMITX_DTOP_BASE + 0x81)
#define  REG_HDMITX_DTOP_41_L       (REG_HDMITX_DTOP_BASE + 0x82)
#define  REG_HDMITX_DTOP_41_H       (REG_HDMITX_DTOP_BASE + 0x83)
#define  REG_HDMITX_DTOP_42_L       (REG_HDMITX_DTOP_BASE + 0x84)
#define  REG_HDMITX_DTOP_42_H       (REG_HDMITX_DTOP_BASE + 0x85)
#define  REG_HDMITX_DTOP_43_L       (REG_HDMITX_DTOP_BASE + 0x86)
#define  REG_HDMITX_DTOP_43_H       (REG_HDMITX_DTOP_BASE + 0x87)
#define  REG_HDMITX_DTOP_44_L       (REG_HDMITX_DTOP_BASE + 0x88)
#define  REG_HDMITX_DTOP_44_H       (REG_HDMITX_DTOP_BASE + 0x89)
#define  REG_HDMITX_DTOP_45_L       (REG_HDMITX_DTOP_BASE + 0x8A)
#define  REG_HDMITX_DTOP_45_H       (REG_HDMITX_DTOP_BASE + 0x8B)
#define  REG_HDMITX_DTOP_46_L       (REG_HDMITX_DTOP_BASE + 0x8C)
#define  REG_HDMITX_DTOP_46_H       (REG_HDMITX_DTOP_BASE + 0x8D)
#define  REG_HDMITX_DTOP_47_L       (REG_HDMITX_DTOP_BASE + 0x8E)
#define  REG_HDMITX_DTOP_47_H       (REG_HDMITX_DTOP_BASE + 0x8F)
#define  REG_HDMITX_DTOP_48_L       (REG_HDMITX_DTOP_BASE + 0x90)
#define  REG_HDMITX_DTOP_48_H       (REG_HDMITX_DTOP_BASE + 0x91)
#define  REG_HDMITX_DTOP_49_L       (REG_HDMITX_DTOP_BASE + 0x92)
#define  REG_HDMITX_DTOP_49_H       (REG_HDMITX_DTOP_BASE + 0x93)
#define  REG_HDMITX_DTOP_4A_L       (REG_HDMITX_DTOP_BASE + 0x94)
#define  REG_HDMITX_DTOP_4A_H       (REG_HDMITX_DTOP_BASE + 0x95)
#define  REG_HDMITX_DTOP_4B_L       (REG_HDMITX_DTOP_BASE + 0x96)
#define  REG_HDMITX_DTOP_4B_H       (REG_HDMITX_DTOP_BASE + 0x97)
#define  REG_HDMITX_DTOP_4C_L       (REG_HDMITX_DTOP_BASE + 0x98)
#define  REG_HDMITX_DTOP_4C_H       (REG_HDMITX_DTOP_BASE + 0x99)
#define  REG_HDMITX_DTOP_4D_L       (REG_HDMITX_DTOP_BASE + 0x9A)
#define  REG_HDMITX_DTOP_4D_H       (REG_HDMITX_DTOP_BASE + 0x9B)
#define  REG_HDMITX_DTOP_4E_L       (REG_HDMITX_DTOP_BASE + 0x9C)
#define  REG_HDMITX_DTOP_4E_H       (REG_HDMITX_DTOP_BASE + 0x9D)
#define  REG_HDMITX_DTOP_4F_L       (REG_HDMITX_DTOP_BASE + 0x9E)
#define  REG_HDMITX_DTOP_4F_H       (REG_HDMITX_DTOP_BASE + 0x9F)
#define  REG_HDMITX_DTOP_50_L       (REG_HDMITX_DTOP_BASE + 0xA0)
#define  REG_HDMITX_DTOP_50_H       (REG_HDMITX_DTOP_BASE + 0xA1)
#define  REG_HDMITX_DTOP_51_L       (REG_HDMITX_DTOP_BASE + 0xA2)
#define  REG_HDMITX_DTOP_51_H       (REG_HDMITX_DTOP_BASE + 0xA3)
#define  REG_HDMITX_DTOP_52_L       (REG_HDMITX_DTOP_BASE + 0xA4)
#define  REG_HDMITX_DTOP_52_H       (REG_HDMITX_DTOP_BASE + 0xA5)
#define  REG_HDMITX_DTOP_53_L       (REG_HDMITX_DTOP_BASE + 0xA6)
#define  REG_HDMITX_DTOP_53_H       (REG_HDMITX_DTOP_BASE + 0xA7)
#define  REG_HDMITX_DTOP_54_L       (REG_HDMITX_DTOP_BASE + 0xA8)
#define  REG_HDMITX_DTOP_54_H       (REG_HDMITX_DTOP_BASE + 0xA9)
#define  REG_HDMITX_DTOP_55_L       (REG_HDMITX_DTOP_BASE + 0xAA)
#define  REG_HDMITX_DTOP_55_H       (REG_HDMITX_DTOP_BASE + 0xAB)
#define  REG_HDMITX_DTOP_56_L       (REG_HDMITX_DTOP_BASE + 0xAC)
#define  REG_HDMITX_DTOP_56_H       (REG_HDMITX_DTOP_BASE + 0xAD)
#define  REG_HDMITX_DTOP_57_L       (REG_HDMITX_DTOP_BASE + 0xAE)
#define  REG_HDMITX_DTOP_57_H       (REG_HDMITX_DTOP_BASE + 0xAF)
#define  REG_HDMITX_DTOP_58_L       (REG_HDMITX_DTOP_BASE + 0xB0)
#define  REG_HDMITX_DTOP_58_H       (REG_HDMITX_DTOP_BASE + 0xB1)
#define  REG_HDMITX_DTOP_59_L       (REG_HDMITX_DTOP_BASE + 0xB2)
#define  REG_HDMITX_DTOP_59_H       (REG_HDMITX_DTOP_BASE + 0xB3)
#define  REG_HDMITX_DTOP_5A_L       (REG_HDMITX_DTOP_BASE + 0xB4)
#define  REG_HDMITX_DTOP_5A_H       (REG_HDMITX_DTOP_BASE + 0xB5)
#define  REG_HDMITX_DTOP_5B_L       (REG_HDMITX_DTOP_BASE + 0xB6)
#define  REG_HDMITX_DTOP_5B_H       (REG_HDMITX_DTOP_BASE + 0xB7)
#define  REG_HDMITX_DTOP_5C_L       (REG_HDMITX_DTOP_BASE + 0xB8)
#define  REG_HDMITX_DTOP_5C_H       (REG_HDMITX_DTOP_BASE + 0xB9)
#define  REG_HDMITX_DTOP_5D_L       (REG_HDMITX_DTOP_BASE + 0xBA)
#define  REG_HDMITX_DTOP_5D_H       (REG_HDMITX_DTOP_BASE + 0xBB)
#define  REG_HDMITX_DTOP_5E_L       (REG_HDMITX_DTOP_BASE + 0xBC)
#define  REG_HDMITX_DTOP_5E_H       (REG_HDMITX_DTOP_BASE + 0xBD)
#define  REG_HDMITX_DTOP_5F_L       (REG_HDMITX_DTOP_BASE + 0xBE)
#define  REG_HDMITX_DTOP_5F_H       (REG_HDMITX_DTOP_BASE + 0xBF)
#define  REG_HDMITX_DTOP_60_L       (REG_HDMITX_DTOP_BASE + 0xC0)
#define  REG_HDMITX_DTOP_60_H       (REG_HDMITX_DTOP_BASE + 0xC1)
#define  REG_HDMITX_DTOP_61_L       (REG_HDMITX_DTOP_BASE + 0xC2)
#define  REG_HDMITX_DTOP_61_H       (REG_HDMITX_DTOP_BASE + 0xC3)
#define  REG_HDMITX_DTOP_62_L       (REG_HDMITX_DTOP_BASE + 0xC4)
#define  REG_HDMITX_DTOP_62_H       (REG_HDMITX_DTOP_BASE + 0xC5)
#define  REG_HDMITX_DTOP_63_L       (REG_HDMITX_DTOP_BASE + 0xC6)
#define  REG_HDMITX_DTOP_63_H       (REG_HDMITX_DTOP_BASE + 0xC7)
#define  REG_HDMITX_DTOP_64_L       (REG_HDMITX_DTOP_BASE + 0xC8)
#define  REG_HDMITX_DTOP_64_H       (REG_HDMITX_DTOP_BASE + 0xC9)
#define  REG_HDMITX_DTOP_65_L       (REG_HDMITX_DTOP_BASE + 0xCA)
#define  REG_HDMITX_DTOP_65_H       (REG_HDMITX_DTOP_BASE + 0xCB)
#define  REG_HDMITX_DTOP_66_L       (REG_HDMITX_DTOP_BASE + 0xCC)
#define  REG_HDMITX_DTOP_66_H       (REG_HDMITX_DTOP_BASE + 0xCD)
#define  REG_HDMITX_DTOP_67_L       (REG_HDMITX_DTOP_BASE + 0xCE)
#define  REG_HDMITX_DTOP_67_H       (REG_HDMITX_DTOP_BASE + 0xCF)
#define  REG_HDMITX_DTOP_68_L       (REG_HDMITX_DTOP_BASE + 0xD0)
#define  REG_HDMITX_DTOP_68_H       (REG_HDMITX_DTOP_BASE + 0xD1)
#define  REG_HDMITX_DTOP_69_L       (REG_HDMITX_DTOP_BASE + 0xD2)
#define  REG_HDMITX_DTOP_69_H       (REG_HDMITX_DTOP_BASE + 0xD3)
#define  REG_HDMITX_DTOP_6A_L       (REG_HDMITX_DTOP_BASE + 0xD4)
#define  REG_HDMITX_DTOP_6A_H       (REG_HDMITX_DTOP_BASE + 0xD5)
#define  REG_HDMITX_DTOP_6B_L       (REG_HDMITX_DTOP_BASE + 0xD6)
#define  REG_HDMITX_DTOP_6B_H       (REG_HDMITX_DTOP_BASE + 0xD7)
#define  REG_HDMITX_DTOP_6C_L       (REG_HDMITX_DTOP_BASE + 0xD8)
#define  REG_HDMITX_DTOP_6C_H       (REG_HDMITX_DTOP_BASE + 0xD9)
#define  REG_HDMITX_DTOP_6D_L       (REG_HDMITX_DTOP_BASE + 0xDA)
#define  REG_HDMITX_DTOP_6D_H       (REG_HDMITX_DTOP_BASE + 0xDB)
#define  REG_HDMITX_DTOP_6E_L       (REG_HDMITX_DTOP_BASE + 0xDC)
#define  REG_HDMITX_DTOP_6E_H       (REG_HDMITX_DTOP_BASE + 0xDD)
#define  REG_HDMITX_DTOP_6F_L       (REG_HDMITX_DTOP_BASE + 0xDE)
#define  REG_HDMITX_DTOP_6F_H       (REG_HDMITX_DTOP_BASE + 0xDF)
#define  REG_HDMITX_DTOP_70_L       (REG_HDMITX_DTOP_BASE + 0xE0)
#define  REG_HDMITX_DTOP_70_H       (REG_HDMITX_DTOP_BASE + 0xE1)
#define  REG_HDMITX_DTOP_71_L       (REG_HDMITX_DTOP_BASE + 0xE2)
#define  REG_HDMITX_DTOP_71_H       (REG_HDMITX_DTOP_BASE + 0xE3)
#define  REG_HDMITX_DTOP_72_L       (REG_HDMITX_DTOP_BASE + 0xE4)
#define  REG_HDMITX_DTOP_72_H       (REG_HDMITX_DTOP_BASE + 0xE5)
#define  REG_HDMITX_DTOP_73_L       (REG_HDMITX_DTOP_BASE + 0xE6)
#define  REG_HDMITX_DTOP_73_H       (REG_HDMITX_DTOP_BASE + 0xE7)
#define  REG_HDMITX_DTOP_74_L       (REG_HDMITX_DTOP_BASE + 0xE8)
#define  REG_HDMITX_DTOP_74_H       (REG_HDMITX_DTOP_BASE + 0xE9)
#define  REG_HDMITX_DTOP_75_L       (REG_HDMITX_DTOP_BASE + 0xEA)
#define  REG_HDMITX_DTOP_75_H       (REG_HDMITX_DTOP_BASE + 0xEB)
#define  REG_HDMITX_DTOP_76_L       (REG_HDMITX_DTOP_BASE + 0xEC)
#define  REG_HDMITX_DTOP_76_H       (REG_HDMITX_DTOP_BASE + 0xED)
#define  REG_HDMITX_DTOP_77_L       (REG_HDMITX_DTOP_BASE + 0xEE)
#define  REG_HDMITX_DTOP_77_H       (REG_HDMITX_DTOP_BASE + 0xEF)
#define  REG_HDMITX_DTOP_78_L       (REG_HDMITX_DTOP_BASE + 0xF0)
#define  REG_HDMITX_DTOP_78_H       (REG_HDMITX_DTOP_BASE + 0xF1)
#define  REG_HDMITX_DTOP_79_L       (REG_HDMITX_DTOP_BASE + 0xF2)
#define  REG_HDMITX_DTOP_79_H       (REG_HDMITX_DTOP_BASE + 0xF3)
#define  REG_HDMITX_DTOP_7A_L       (REG_HDMITX_DTOP_BASE + 0xF4)
#define  REG_HDMITX_DTOP_7A_H       (REG_HDMITX_DTOP_BASE + 0xF5)
#define  REG_HDMITX_DTOP_7B_L       (REG_HDMITX_DTOP_BASE + 0xF6)
#define  REG_HDMITX_DTOP_7B_H       (REG_HDMITX_DTOP_BASE + 0xF7)
#define  REG_HDMITX_DTOP_7C_L       (REG_HDMITX_DTOP_BASE + 0xF8)
#define  REG_HDMITX_DTOP_7C_H       (REG_HDMITX_DTOP_BASE + 0xF9)
#define  REG_HDMITX_DTOP_7D_L       (REG_HDMITX_DTOP_BASE + 0xFA)
#define  REG_HDMITX_DTOP_7D_H       (REG_HDMITX_DTOP_BASE + 0xFB)
#define  REG_HDMITX_DTOP_7E_L       (REG_HDMITX_DTOP_BASE + 0xFC)
#define  REG_HDMITX_DTOP_7E_H       (REG_HDMITX_DTOP_BASE + 0xFD)
#define  REG_HDMITX_DTOP_7F_L       (REG_HDMITX_DTOP_BASE + 0xFE)
#define  REG_HDMITX_DTOP_7F_H       (REG_HDMITX_DTOP_BASE + 0xFF)

#define  REG_DAC_ATOP_00_L       (REG_DAC_ATOP_BASE + 0x00)
#define  REG_DAC_ATOP_00_H       (REG_DAC_ATOP_BASE + 0x01)
#define  REG_DAC_ATOP_01_L       (REG_DAC_ATOP_BASE + 0x02)
#define  REG_DAC_ATOP_01_H       (REG_DAC_ATOP_BASE + 0x03)
#define  REG_DAC_ATOP_02_L       (REG_DAC_ATOP_BASE + 0x04)
#define  REG_DAC_ATOP_02_H       (REG_DAC_ATOP_BASE + 0x05)
#define  REG_DAC_ATOP_03_L       (REG_DAC_ATOP_BASE + 0x06)
#define  REG_DAC_ATOP_03_H       (REG_DAC_ATOP_BASE + 0x07)
#define  REG_DAC_ATOP_04_L       (REG_DAC_ATOP_BASE + 0x08)
#define  REG_DAC_ATOP_04_H       (REG_DAC_ATOP_BASE + 0x09)
#define  REG_DAC_ATOP_05_L       (REG_DAC_ATOP_BASE + 0x0A)
#define  REG_DAC_ATOP_05_H       (REG_DAC_ATOP_BASE + 0x0B)
#define  REG_DAC_ATOP_06_L       (REG_DAC_ATOP_BASE + 0x0C)
#define  REG_DAC_ATOP_06_H       (REG_DAC_ATOP_BASE + 0x0D)
#define  REG_DAC_ATOP_07_L       (REG_DAC_ATOP_BASE + 0x0E)
#define  REG_DAC_ATOP_07_H       (REG_DAC_ATOP_BASE + 0x0F)
#define  REG_DAC_ATOP_08_L       (REG_DAC_ATOP_BASE + 0x10)
#define  REG_DAC_ATOP_08_H       (REG_DAC_ATOP_BASE + 0x11)
#define  REG_DAC_ATOP_09_L       (REG_DAC_ATOP_BASE + 0x12)
#define  REG_DAC_ATOP_09_H       (REG_DAC_ATOP_BASE + 0x13)
#define  REG_DAC_ATOP_0A_L       (REG_DAC_ATOP_BASE + 0x14)
#define  REG_DAC_ATOP_0A_H       (REG_DAC_ATOP_BASE + 0x15)
#define  REG_DAC_ATOP_0B_L       (REG_DAC_ATOP_BASE + 0x16)
#define  REG_DAC_ATOP_0B_H       (REG_DAC_ATOP_BASE + 0x17)
#define  REG_DAC_ATOP_0C_L       (REG_DAC_ATOP_BASE + 0x18)
#define  REG_DAC_ATOP_0C_H       (REG_DAC_ATOP_BASE + 0x19)
#define  REG_DAC_ATOP_0D_L       (REG_DAC_ATOP_BASE + 0x1A)
#define  REG_DAC_ATOP_0D_H       (REG_DAC_ATOP_BASE + 0x1B)
#define  REG_DAC_ATOP_0E_L       (REG_DAC_ATOP_BASE + 0x1C)
#define  REG_DAC_ATOP_0E_H       (REG_DAC_ATOP_BASE + 0x1D)
#define  REG_DAC_ATOP_0F_L       (REG_DAC_ATOP_BASE + 0x1E)
#define  REG_DAC_ATOP_0F_H       (REG_DAC_ATOP_BASE + 0x1F)
#define  REG_DAC_ATOP_10_L       (REG_DAC_ATOP_BASE + 0x20)
#define  REG_DAC_ATOP_10_H       (REG_DAC_ATOP_BASE + 0x21)
#define  REG_DAC_ATOP_11_L       (REG_DAC_ATOP_BASE + 0x22)
#define  REG_DAC_ATOP_11_H       (REG_DAC_ATOP_BASE + 0x23)
#define  REG_DAC_ATOP_12_L       (REG_DAC_ATOP_BASE + 0x24)
#define  REG_DAC_ATOP_12_H       (REG_DAC_ATOP_BASE + 0x25)
#define  REG_DAC_ATOP_13_L       (REG_DAC_ATOP_BASE + 0x26)
#define  REG_DAC_ATOP_13_H       (REG_DAC_ATOP_BASE + 0x27)
#define  REG_DAC_ATOP_14_L       (REG_DAC_ATOP_BASE + 0x28)
#define  REG_DAC_ATOP_14_H       (REG_DAC_ATOP_BASE + 0x29)
#define  REG_DAC_ATOP_15_L       (REG_DAC_ATOP_BASE + 0x2A)
#define  REG_DAC_ATOP_15_H       (REG_DAC_ATOP_BASE + 0x2B)
#define  REG_DAC_ATOP_16_L       (REG_DAC_ATOP_BASE + 0x2C)
#define  REG_DAC_ATOP_16_H       (REG_DAC_ATOP_BASE + 0x2D)
#define  REG_DAC_ATOP_17_L       (REG_DAC_ATOP_BASE + 0x2E)
#define  REG_DAC_ATOP_17_H       (REG_DAC_ATOP_BASE + 0x2F)
#define  REG_DAC_ATOP_18_L       (REG_DAC_ATOP_BASE + 0x30)
#define  REG_DAC_ATOP_18_H       (REG_DAC_ATOP_BASE + 0x31)
#define  REG_DAC_ATOP_19_L       (REG_DAC_ATOP_BASE + 0x32)
#define  REG_DAC_ATOP_19_H       (REG_DAC_ATOP_BASE + 0x33)
#define  REG_DAC_ATOP_1A_L       (REG_DAC_ATOP_BASE + 0x34)
#define  REG_DAC_ATOP_1A_H       (REG_DAC_ATOP_BASE + 0x35)
#define  REG_DAC_ATOP_1B_L       (REG_DAC_ATOP_BASE + 0x36)
#define  REG_DAC_ATOP_1B_H       (REG_DAC_ATOP_BASE + 0x37)
#define  REG_DAC_ATOP_1C_L       (REG_DAC_ATOP_BASE + 0x38)
#define  REG_DAC_ATOP_1C_H       (REG_DAC_ATOP_BASE + 0x39)
#define  REG_DAC_ATOP_1D_L       (REG_DAC_ATOP_BASE + 0x3A)
#define  REG_DAC_ATOP_1D_H       (REG_DAC_ATOP_BASE + 0x3B)
#define  REG_DAC_ATOP_1E_L       (REG_DAC_ATOP_BASE + 0x3C)
#define  REG_DAC_ATOP_1E_H       (REG_DAC_ATOP_BASE + 0x3D)
#define  REG_DAC_ATOP_1F_L       (REG_DAC_ATOP_BASE + 0x3E)
#define  REG_DAC_ATOP_1F_H       (REG_DAC_ATOP_BASE + 0x3F)
#define  REG_DAC_ATOP_20_L       (REG_DAC_ATOP_BASE + 0x40)
#define  REG_DAC_ATOP_20_H       (REG_DAC_ATOP_BASE + 0x41)
#define  REG_DAC_ATOP_21_L       (REG_DAC_ATOP_BASE + 0x42)
#define  REG_DAC_ATOP_21_H       (REG_DAC_ATOP_BASE + 0x43)
#define  REG_DAC_ATOP_22_L       (REG_DAC_ATOP_BASE + 0x44)
#define  REG_DAC_ATOP_22_H       (REG_DAC_ATOP_BASE + 0x45)
#define  REG_DAC_ATOP_23_L       (REG_DAC_ATOP_BASE + 0x46)
#define  REG_DAC_ATOP_23_H       (REG_DAC_ATOP_BASE + 0x47)
#define  REG_DAC_ATOP_24_L       (REG_DAC_ATOP_BASE + 0x48)
#define  REG_DAC_ATOP_24_H       (REG_DAC_ATOP_BASE + 0x49)
#define  REG_DAC_ATOP_25_L       (REG_DAC_ATOP_BASE + 0x4A)
#define  REG_DAC_ATOP_25_H       (REG_DAC_ATOP_BASE + 0x4B)
#define  REG_DAC_ATOP_26_L       (REG_DAC_ATOP_BASE + 0x4C)
#define  REG_DAC_ATOP_26_H       (REG_DAC_ATOP_BASE + 0x4D)
#define  REG_DAC_ATOP_27_L       (REG_DAC_ATOP_BASE + 0x4E)
#define  REG_DAC_ATOP_27_H       (REG_DAC_ATOP_BASE + 0x4F)
#define  REG_DAC_ATOP_28_L       (REG_DAC_ATOP_BASE + 0x50)
#define  REG_DAC_ATOP_28_H       (REG_DAC_ATOP_BASE + 0x51)
#define  REG_DAC_ATOP_29_L       (REG_DAC_ATOP_BASE + 0x52)
#define  REG_DAC_ATOP_29_H       (REG_DAC_ATOP_BASE + 0x53)
#define  REG_DAC_ATOP_2A_L       (REG_DAC_ATOP_BASE + 0x54)
#define  REG_DAC_ATOP_2A_H       (REG_DAC_ATOP_BASE + 0x55)
#define  REG_DAC_ATOP_2B_L       (REG_DAC_ATOP_BASE + 0x56)
#define  REG_DAC_ATOP_2B_H       (REG_DAC_ATOP_BASE + 0x57)
#define  REG_DAC_ATOP_2C_L       (REG_DAC_ATOP_BASE + 0x58)
#define  REG_DAC_ATOP_2C_H       (REG_DAC_ATOP_BASE + 0x59)
#define  REG_DAC_ATOP_2D_L       (REG_DAC_ATOP_BASE + 0x5A)
#define  REG_DAC_ATOP_2D_H       (REG_DAC_ATOP_BASE + 0x5B)
#define  REG_DAC_ATOP_2E_L       (REG_DAC_ATOP_BASE + 0x5C)
#define  REG_DAC_ATOP_2E_H       (REG_DAC_ATOP_BASE + 0x5D)
#define  REG_DAC_ATOP_2F_L       (REG_DAC_ATOP_BASE + 0x5E)
#define  REG_DAC_ATOP_2F_H       (REG_DAC_ATOP_BASE + 0x5F)
#define  REG_DAC_ATOP_30_L       (REG_DAC_ATOP_BASE + 0x60)
#define  REG_DAC_ATOP_30_H       (REG_DAC_ATOP_BASE + 0x61)
#define  REG_DAC_ATOP_31_L       (REG_DAC_ATOP_BASE + 0x62)
#define  REG_DAC_ATOP_31_H       (REG_DAC_ATOP_BASE + 0x63)
#define  REG_DAC_ATOP_32_L       (REG_DAC_ATOP_BASE + 0x64)
#define  REG_DAC_ATOP_32_H       (REG_DAC_ATOP_BASE + 0x65)
#define  REG_DAC_ATOP_33_L       (REG_DAC_ATOP_BASE + 0x66)
#define  REG_DAC_ATOP_33_H       (REG_DAC_ATOP_BASE + 0x67)
#define  REG_DAC_ATOP_34_L       (REG_DAC_ATOP_BASE + 0x68)
#define  REG_DAC_ATOP_34_H       (REG_DAC_ATOP_BASE + 0x69)
#define  REG_DAC_ATOP_35_L       (REG_DAC_ATOP_BASE + 0x6A)
#define  REG_DAC_ATOP_35_H       (REG_DAC_ATOP_BASE + 0x6B)
#define  REG_DAC_ATOP_36_L       (REG_DAC_ATOP_BASE + 0x6C)
#define  REG_DAC_ATOP_36_H       (REG_DAC_ATOP_BASE + 0x6D)
#define  REG_DAC_ATOP_37_L       (REG_DAC_ATOP_BASE + 0x6E)
#define  REG_DAC_ATOP_37_H       (REG_DAC_ATOP_BASE + 0x6F)
#define  REG_DAC_ATOP_38_L       (REG_DAC_ATOP_BASE + 0x70)
#define  REG_DAC_ATOP_38_H       (REG_DAC_ATOP_BASE + 0x71)
#define  REG_DAC_ATOP_39_L       (REG_DAC_ATOP_BASE + 0x72)
#define  REG_DAC_ATOP_39_H       (REG_DAC_ATOP_BASE + 0x73)
#define  REG_DAC_ATOP_3A_L       (REG_DAC_ATOP_BASE + 0x74)
#define  REG_DAC_ATOP_3A_H       (REG_DAC_ATOP_BASE + 0x75)
#define  REG_DAC_ATOP_3B_L       (REG_DAC_ATOP_BASE + 0x76)
#define  REG_DAC_ATOP_3B_H       (REG_DAC_ATOP_BASE + 0x77)
#define  REG_DAC_ATOP_3C_L       (REG_DAC_ATOP_BASE + 0x78)
#define  REG_DAC_ATOP_3C_H       (REG_DAC_ATOP_BASE + 0x79)
#define  REG_DAC_ATOP_3D_L       (REG_DAC_ATOP_BASE + 0x7A)
#define  REG_DAC_ATOP_3D_H       (REG_DAC_ATOP_BASE + 0x7B)
#define  REG_DAC_ATOP_3E_L       (REG_DAC_ATOP_BASE + 0x7C)
#define  REG_DAC_ATOP_3E_H       (REG_DAC_ATOP_BASE + 0x7D)
#define  REG_DAC_ATOP_3F_L       (REG_DAC_ATOP_BASE + 0x7E)
#define  REG_DAC_ATOP_3F_H       (REG_DAC_ATOP_BASE + 0x7F)
#define  REG_DAC_ATOP_40_L       (REG_DAC_ATOP_BASE + 0x80)
#define  REG_DAC_ATOP_40_H       (REG_DAC_ATOP_BASE + 0x81)
#define  REG_DAC_ATOP_41_L       (REG_DAC_ATOP_BASE + 0x82)
#define  REG_DAC_ATOP_41_H       (REG_DAC_ATOP_BASE + 0x83)
#define  REG_DAC_ATOP_42_L       (REG_DAC_ATOP_BASE + 0x84)
#define  REG_DAC_ATOP_42_H       (REG_DAC_ATOP_BASE + 0x85)
#define  REG_DAC_ATOP_43_L       (REG_DAC_ATOP_BASE + 0x86)
#define  REG_DAC_ATOP_43_H       (REG_DAC_ATOP_BASE + 0x87)
#define  REG_DAC_ATOP_44_L       (REG_DAC_ATOP_BASE + 0x88)
#define  REG_DAC_ATOP_44_H       (REG_DAC_ATOP_BASE + 0x89)
#define  REG_DAC_ATOP_45_L       (REG_DAC_ATOP_BASE + 0x8A)
#define  REG_DAC_ATOP_45_H       (REG_DAC_ATOP_BASE + 0x8B)
#define  REG_DAC_ATOP_46_L       (REG_DAC_ATOP_BASE + 0x8C)
#define  REG_DAC_ATOP_46_H       (REG_DAC_ATOP_BASE + 0x8D)
#define  REG_DAC_ATOP_47_L       (REG_DAC_ATOP_BASE + 0x8E)
#define  REG_DAC_ATOP_47_H       (REG_DAC_ATOP_BASE + 0x8F)
#define  REG_DAC_ATOP_48_L       (REG_DAC_ATOP_BASE + 0x90)
#define  REG_DAC_ATOP_48_H       (REG_DAC_ATOP_BASE + 0x91)
#define  REG_DAC_ATOP_49_L       (REG_DAC_ATOP_BASE + 0x92)
#define  REG_DAC_ATOP_49_H       (REG_DAC_ATOP_BASE + 0x93)
#define  REG_DAC_ATOP_4A_L       (REG_DAC_ATOP_BASE + 0x94)
#define  REG_DAC_ATOP_4A_H       (REG_DAC_ATOP_BASE + 0x95)
#define  REG_DAC_ATOP_4B_L       (REG_DAC_ATOP_BASE + 0x96)
#define  REG_DAC_ATOP_4B_H       (REG_DAC_ATOP_BASE + 0x97)
#define  REG_DAC_ATOP_4C_L       (REG_DAC_ATOP_BASE + 0x98)
#define  REG_DAC_ATOP_4C_H       (REG_DAC_ATOP_BASE + 0x99)
#define  REG_DAC_ATOP_4D_L       (REG_DAC_ATOP_BASE + 0x9A)
#define  REG_DAC_ATOP_4D_H       (REG_DAC_ATOP_BASE + 0x9B)
#define  REG_DAC_ATOP_4E_L       (REG_DAC_ATOP_BASE + 0x9C)
#define  REG_DAC_ATOP_4E_H       (REG_DAC_ATOP_BASE + 0x9D)
#define  REG_DAC_ATOP_4F_L       (REG_DAC_ATOP_BASE + 0x9E)
#define  REG_DAC_ATOP_4F_H       (REG_DAC_ATOP_BASE + 0x9F)
#define  REG_DAC_ATOP_50_L       (REG_DAC_ATOP_BASE + 0xA0)
#define  REG_DAC_ATOP_50_H       (REG_DAC_ATOP_BASE + 0xA1)
#define  REG_DAC_ATOP_51_L       (REG_DAC_ATOP_BASE + 0xA2)
#define  REG_DAC_ATOP_51_H       (REG_DAC_ATOP_BASE + 0xA3)
#define  REG_DAC_ATOP_52_L       (REG_DAC_ATOP_BASE + 0xA4)
#define  REG_DAC_ATOP_52_H       (REG_DAC_ATOP_BASE + 0xA5)
#define  REG_DAC_ATOP_53_L       (REG_DAC_ATOP_BASE + 0xA6)
#define  REG_DAC_ATOP_53_H       (REG_DAC_ATOP_BASE + 0xA7)
#define  REG_DAC_ATOP_54_L       (REG_DAC_ATOP_BASE + 0xA8)
#define  REG_DAC_ATOP_54_H       (REG_DAC_ATOP_BASE + 0xA9)
#define  REG_DAC_ATOP_55_L       (REG_DAC_ATOP_BASE + 0xAA)
#define  REG_DAC_ATOP_55_H       (REG_DAC_ATOP_BASE + 0xAB)
#define  REG_DAC_ATOP_56_L       (REG_DAC_ATOP_BASE + 0xAC)
#define  REG_DAC_ATOP_56_H       (REG_DAC_ATOP_BASE + 0xAD)
#define  REG_DAC_ATOP_57_L       (REG_DAC_ATOP_BASE + 0xAE)
#define  REG_DAC_ATOP_57_H       (REG_DAC_ATOP_BASE + 0xAF)
#define  REG_DAC_ATOP_58_L       (REG_DAC_ATOP_BASE + 0xB0)
#define  REG_DAC_ATOP_58_H       (REG_DAC_ATOP_BASE + 0xB1)
#define  REG_DAC_ATOP_59_L       (REG_DAC_ATOP_BASE + 0xB2)
#define  REG_DAC_ATOP_59_H       (REG_DAC_ATOP_BASE + 0xB3)
#define  REG_DAC_ATOP_5A_L       (REG_DAC_ATOP_BASE + 0xB4)
#define  REG_DAC_ATOP_5A_H       (REG_DAC_ATOP_BASE + 0xB5)
#define  REG_DAC_ATOP_5B_L       (REG_DAC_ATOP_BASE + 0xB6)
#define  REG_DAC_ATOP_5B_H       (REG_DAC_ATOP_BASE + 0xB7)
#define  REG_DAC_ATOP_5C_L       (REG_DAC_ATOP_BASE + 0xB8)
#define  REG_DAC_ATOP_5C_H       (REG_DAC_ATOP_BASE + 0xB9)
#define  REG_DAC_ATOP_5D_L       (REG_DAC_ATOP_BASE + 0xBA)
#define  REG_DAC_ATOP_5D_H       (REG_DAC_ATOP_BASE + 0xBB)
#define  REG_DAC_ATOP_5E_L       (REG_DAC_ATOP_BASE + 0xBC)
#define  REG_DAC_ATOP_5E_H       (REG_DAC_ATOP_BASE + 0xBD)
#define  REG_DAC_ATOP_5F_L       (REG_DAC_ATOP_BASE + 0xBE)
#define  REG_DAC_ATOP_5F_H       (REG_DAC_ATOP_BASE + 0xBF)
#define  REG_DAC_ATOP_60_L       (REG_DAC_ATOP_BASE + 0xC0)
#define  REG_DAC_ATOP_60_H       (REG_DAC_ATOP_BASE + 0xC1)
#define  REG_DAC_ATOP_61_L       (REG_DAC_ATOP_BASE + 0xC2)
#define  REG_DAC_ATOP_61_H       (REG_DAC_ATOP_BASE + 0xC3)
#define  REG_DAC_ATOP_62_L       (REG_DAC_ATOP_BASE + 0xC4)
#define  REG_DAC_ATOP_62_H       (REG_DAC_ATOP_BASE + 0xC5)
#define  REG_DAC_ATOP_63_L       (REG_DAC_ATOP_BASE + 0xC6)
#define  REG_DAC_ATOP_63_H       (REG_DAC_ATOP_BASE + 0xC7)
#define  REG_DAC_ATOP_64_L       (REG_DAC_ATOP_BASE + 0xC8)
#define  REG_DAC_ATOP_64_H       (REG_DAC_ATOP_BASE + 0xC9)
#define  REG_DAC_ATOP_65_L       (REG_DAC_ATOP_BASE + 0xCA)
#define  REG_DAC_ATOP_65_H       (REG_DAC_ATOP_BASE + 0xCB)
#define  REG_DAC_ATOP_66_L       (REG_DAC_ATOP_BASE + 0xCC)
#define  REG_DAC_ATOP_66_H       (REG_DAC_ATOP_BASE + 0xCD)
#define  REG_DAC_ATOP_67_L       (REG_DAC_ATOP_BASE + 0xCE)
#define  REG_DAC_ATOP_67_H       (REG_DAC_ATOP_BASE + 0xCF)
#define  REG_DAC_ATOP_68_L       (REG_DAC_ATOP_BASE + 0xD0)
#define  REG_DAC_ATOP_68_H       (REG_DAC_ATOP_BASE + 0xD1)
#define  REG_DAC_ATOP_69_L       (REG_DAC_ATOP_BASE + 0xD2)
#define  REG_DAC_ATOP_69_H       (REG_DAC_ATOP_BASE + 0xD3)
#define  REG_DAC_ATOP_6A_L       (REG_DAC_ATOP_BASE + 0xD4)
#define  REG_DAC_ATOP_6A_H       (REG_DAC_ATOP_BASE + 0xD5)
#define  REG_DAC_ATOP_6B_L       (REG_DAC_ATOP_BASE + 0xD6)
#define  REG_DAC_ATOP_6B_H       (REG_DAC_ATOP_BASE + 0xD7)
#define  REG_DAC_ATOP_6C_L       (REG_DAC_ATOP_BASE + 0xD8)
#define  REG_DAC_ATOP_6C_H       (REG_DAC_ATOP_BASE + 0xD9)
#define  REG_DAC_ATOP_6D_L       (REG_DAC_ATOP_BASE + 0xDA)
#define  REG_DAC_ATOP_6D_H       (REG_DAC_ATOP_BASE + 0xDB)
#define  REG_DAC_ATOP_6E_L       (REG_DAC_ATOP_BASE + 0xDC)
#define  REG_DAC_ATOP_6E_H       (REG_DAC_ATOP_BASE + 0xDD)
#define  REG_DAC_ATOP_6F_L       (REG_DAC_ATOP_BASE + 0xDE)
#define  REG_DAC_ATOP_6F_H       (REG_DAC_ATOP_BASE + 0xDF)
#define  REG_DAC_ATOP_70_L       (REG_DAC_ATOP_BASE + 0xE0)
#define  REG_DAC_ATOP_70_H       (REG_DAC_ATOP_BASE + 0xE1)
#define  REG_DAC_ATOP_71_L       (REG_DAC_ATOP_BASE + 0xE2)
#define  REG_DAC_ATOP_71_H       (REG_DAC_ATOP_BASE + 0xE3)
#define  REG_DAC_ATOP_72_L       (REG_DAC_ATOP_BASE + 0xE4)
#define  REG_DAC_ATOP_72_H       (REG_DAC_ATOP_BASE + 0xE5)
#define  REG_DAC_ATOP_73_L       (REG_DAC_ATOP_BASE + 0xE6)
#define  REG_DAC_ATOP_73_H       (REG_DAC_ATOP_BASE + 0xE7)
#define  REG_DAC_ATOP_74_L       (REG_DAC_ATOP_BASE + 0xE8)
#define  REG_DAC_ATOP_74_H       (REG_DAC_ATOP_BASE + 0xE9)
#define  REG_DAC_ATOP_75_L       (REG_DAC_ATOP_BASE + 0xEA)
#define  REG_DAC_ATOP_75_H       (REG_DAC_ATOP_BASE + 0xEB)
#define  REG_DAC_ATOP_76_L       (REG_DAC_ATOP_BASE + 0xEC)
#define  REG_DAC_ATOP_76_H       (REG_DAC_ATOP_BASE + 0xED)
#define  REG_DAC_ATOP_77_L       (REG_DAC_ATOP_BASE + 0xEE)
#define  REG_DAC_ATOP_77_H       (REG_DAC_ATOP_BASE + 0xEF)
#define  REG_DAC_ATOP_78_L       (REG_DAC_ATOP_BASE + 0xF0)
#define  REG_DAC_ATOP_78_H       (REG_DAC_ATOP_BASE + 0xF1)
#define  REG_DAC_ATOP_79_L       (REG_DAC_ATOP_BASE + 0xF2)
#define  REG_DAC_ATOP_79_H       (REG_DAC_ATOP_BASE + 0xF3)
#define  REG_DAC_ATOP_7A_L       (REG_DAC_ATOP_BASE + 0xF4)
#define  REG_DAC_ATOP_7A_H       (REG_DAC_ATOP_BASE + 0xF5)
#define  REG_DAC_ATOP_7B_L       (REG_DAC_ATOP_BASE + 0xF6)
#define  REG_DAC_ATOP_7B_H       (REG_DAC_ATOP_BASE + 0xF7)
#define  REG_DAC_ATOP_7C_L       (REG_DAC_ATOP_BASE + 0xF8)
#define  REG_DAC_ATOP_7C_H       (REG_DAC_ATOP_BASE + 0xF9)
#define  REG_DAC_ATOP_7D_L       (REG_DAC_ATOP_BASE + 0xFA)
#define  REG_DAC_ATOP_7D_H       (REG_DAC_ATOP_BASE + 0xFB)
#define  REG_DAC_ATOP_7E_L       (REG_DAC_ATOP_BASE + 0xFC)
#define  REG_DAC_ATOP_7E_H       (REG_DAC_ATOP_BASE + 0xFD)
#define  REG_DAC_ATOP_7F_L       (REG_DAC_ATOP_BASE + 0xFE)
#define  REG_DAC_ATOP_7F_H       (REG_DAC_ATOP_BASE + 0xFF)

#define  REG_DISP_TOP_00_L       (REG_DISP_TOP_BASE + 0x00)
#define  REG_DISP_TOP_00_H       (REG_DISP_TOP_BASE + 0x01)
#define  REG_DISP_TOP_01_L       (REG_DISP_TOP_BASE + 0x02)
#define  REG_DISP_TOP_01_H       (REG_DISP_TOP_BASE + 0x03)
#define  REG_DISP_TOP_02_L       (REG_DISP_TOP_BASE + 0x04)
#define  REG_DISP_TOP_02_H       (REG_DISP_TOP_BASE + 0x05)
#define  REG_DISP_TOP_03_L       (REG_DISP_TOP_BASE + 0x06)
#define  REG_DISP_TOP_03_H       (REG_DISP_TOP_BASE + 0x07)
#define  REG_DISP_TOP_04_L       (REG_DISP_TOP_BASE + 0x08)
#define  REG_DISP_TOP_04_H       (REG_DISP_TOP_BASE + 0x09)
#define  REG_DISP_TOP_05_L       (REG_DISP_TOP_BASE + 0x0A)
#define  REG_DISP_TOP_05_H       (REG_DISP_TOP_BASE + 0x0B)
#define  REG_DISP_TOP_06_L       (REG_DISP_TOP_BASE + 0x0C)
#define  REG_DISP_TOP_06_H       (REG_DISP_TOP_BASE + 0x0D)
#define  REG_DISP_TOP_07_L       (REG_DISP_TOP_BASE + 0x0E)
#define  REG_DISP_TOP_07_H       (REG_DISP_TOP_BASE + 0x0F)
#define  REG_DISP_TOP_08_L       (REG_DISP_TOP_BASE + 0x10)
#define  REG_DISP_TOP_08_H       (REG_DISP_TOP_BASE + 0x11)
#define  REG_DISP_TOP_09_L       (REG_DISP_TOP_BASE + 0x12)
#define  REG_DISP_TOP_09_H       (REG_DISP_TOP_BASE + 0x13)
#define  REG_DISP_TOP_0A_L       (REG_DISP_TOP_BASE + 0x14)
#define  REG_DISP_TOP_0A_H       (REG_DISP_TOP_BASE + 0x15)
#define  REG_DISP_TOP_0B_L       (REG_DISP_TOP_BASE + 0x16)
#define  REG_DISP_TOP_0B_H       (REG_DISP_TOP_BASE + 0x17)
#define  REG_DISP_TOP_0C_L       (REG_DISP_TOP_BASE + 0x18)
#define  REG_DISP_TOP_0C_H       (REG_DISP_TOP_BASE + 0x19)
#define  REG_DISP_TOP_0D_L       (REG_DISP_TOP_BASE + 0x1A)
#define  REG_DISP_TOP_0D_H       (REG_DISP_TOP_BASE + 0x1B)
#define  REG_DISP_TOP_0E_L       (REG_DISP_TOP_BASE + 0x1C)
#define  REG_DISP_TOP_0E_H       (REG_DISP_TOP_BASE + 0x1D)
#define  REG_DISP_TOP_0F_L       (REG_DISP_TOP_BASE + 0x1E)
#define  REG_DISP_TOP_0F_H       (REG_DISP_TOP_BASE + 0x1F)
#define  REG_DISP_TOP_10_L       (REG_DISP_TOP_BASE + 0x20)
#define  REG_DISP_TOP_10_H       (REG_DISP_TOP_BASE + 0x21)
#define  REG_DISP_TOP_11_L       (REG_DISP_TOP_BASE + 0x22)
#define  REG_DISP_TOP_11_H       (REG_DISP_TOP_BASE + 0x23)
#define  REG_DISP_TOP_12_L       (REG_DISP_TOP_BASE + 0x24)
#define  REG_DISP_TOP_12_H       (REG_DISP_TOP_BASE + 0x25)
#define  REG_DISP_TOP_13_L       (REG_DISP_TOP_BASE + 0x26)
#define  REG_DISP_TOP_13_H       (REG_DISP_TOP_BASE + 0x27)
#define  REG_DISP_TOP_14_L       (REG_DISP_TOP_BASE + 0x28)
#define  REG_DISP_TOP_14_H       (REG_DISP_TOP_BASE + 0x29)
#define  REG_DISP_TOP_15_L       (REG_DISP_TOP_BASE + 0x2A)
#define  REG_DISP_TOP_15_H       (REG_DISP_TOP_BASE + 0x2B)
#define  REG_DISP_TOP_16_L       (REG_DISP_TOP_BASE + 0x2C)
#define  REG_DISP_TOP_16_H       (REG_DISP_TOP_BASE + 0x2D)
#define  REG_DISP_TOP_17_L       (REG_DISP_TOP_BASE + 0x2E)
#define  REG_DISP_TOP_17_H       (REG_DISP_TOP_BASE + 0x2F)
#define  REG_DISP_TOP_18_L       (REG_DISP_TOP_BASE + 0x30)
#define  REG_DISP_TOP_18_H       (REG_DISP_TOP_BASE + 0x31)
#define  REG_DISP_TOP_19_L       (REG_DISP_TOP_BASE + 0x32)
#define  REG_DISP_TOP_19_H       (REG_DISP_TOP_BASE + 0x33)
#define  REG_DISP_TOP_1A_L       (REG_DISP_TOP_BASE + 0x34)
#define  REG_DISP_TOP_1A_H       (REG_DISP_TOP_BASE + 0x35)
#define  REG_DISP_TOP_1B_L       (REG_DISP_TOP_BASE + 0x36)
#define  REG_DISP_TOP_1B_H       (REG_DISP_TOP_BASE + 0x37)
#define  REG_DISP_TOP_1C_L       (REG_DISP_TOP_BASE + 0x38)
#define  REG_DISP_TOP_1C_H       (REG_DISP_TOP_BASE + 0x39)
#define  REG_DISP_TOP_1D_L       (REG_DISP_TOP_BASE + 0x3A)
#define  REG_DISP_TOP_1D_H       (REG_DISP_TOP_BASE + 0x3B)
#define  REG_DISP_TOP_1E_L       (REG_DISP_TOP_BASE + 0x3C)
#define  REG_DISP_TOP_1E_H       (REG_DISP_TOP_BASE + 0x3D)
#define  REG_DISP_TOP_1F_L       (REG_DISP_TOP_BASE + 0x3E)
#define  REG_DISP_TOP_1F_H       (REG_DISP_TOP_BASE + 0x3F)
#define  REG_DISP_TOP_20_L       (REG_DISP_TOP_BASE + 0x40)
#define  REG_DISP_TOP_20_H       (REG_DISP_TOP_BASE + 0x41)
#define  REG_DISP_TOP_21_L       (REG_DISP_TOP_BASE + 0x42)
#define  REG_DISP_TOP_21_H       (REG_DISP_TOP_BASE + 0x43)
#define  REG_DISP_TOP_22_L       (REG_DISP_TOP_BASE + 0x44)
#define  REG_DISP_TOP_22_H       (REG_DISP_TOP_BASE + 0x45)
#define  REG_DISP_TOP_23_L       (REG_DISP_TOP_BASE + 0x46)
#define  REG_DISP_TOP_23_H       (REG_DISP_TOP_BASE + 0x47)
#define  REG_DISP_TOP_24_L       (REG_DISP_TOP_BASE + 0x48)
#define  REG_DISP_TOP_24_H       (REG_DISP_TOP_BASE + 0x49)
#define  REG_DISP_TOP_25_L       (REG_DISP_TOP_BASE + 0x4A)
#define  REG_DISP_TOP_25_H       (REG_DISP_TOP_BASE + 0x4B)
#define  REG_DISP_TOP_26_L       (REG_DISP_TOP_BASE + 0x4C)
#define  REG_DISP_TOP_26_H       (REG_DISP_TOP_BASE + 0x4D)
#define  REG_DISP_TOP_27_L       (REG_DISP_TOP_BASE + 0x4E)
#define  REG_DISP_TOP_27_H       (REG_DISP_TOP_BASE + 0x4F)
#define  REG_DISP_TOP_28_L       (REG_DISP_TOP_BASE + 0x50)
#define  REG_DISP_TOP_28_H       (REG_DISP_TOP_BASE + 0x51)
#define  REG_DISP_TOP_29_L       (REG_DISP_TOP_BASE + 0x52)
#define  REG_DISP_TOP_29_H       (REG_DISP_TOP_BASE + 0x53)
#define  REG_DISP_TOP_2A_L       (REG_DISP_TOP_BASE + 0x54)
#define  REG_DISP_TOP_2A_H       (REG_DISP_TOP_BASE + 0x55)
#define  REG_DISP_TOP_2B_L       (REG_DISP_TOP_BASE + 0x56)
#define  REG_DISP_TOP_2B_H       (REG_DISP_TOP_BASE + 0x57)
#define  REG_DISP_TOP_2C_L       (REG_DISP_TOP_BASE + 0x58)
#define  REG_DISP_TOP_2C_H       (REG_DISP_TOP_BASE + 0x59)
#define  REG_DISP_TOP_2D_L       (REG_DISP_TOP_BASE + 0x5A)
#define  REG_DISP_TOP_2D_H       (REG_DISP_TOP_BASE + 0x5B)
#define  REG_DISP_TOP_2E_L       (REG_DISP_TOP_BASE + 0x5C)
#define  REG_DISP_TOP_2E_H       (REG_DISP_TOP_BASE + 0x5D)
#define  REG_DISP_TOP_2F_L       (REG_DISP_TOP_BASE + 0x5E)
#define  REG_DISP_TOP_2F_H       (REG_DISP_TOP_BASE + 0x5F)
#define  REG_DISP_TOP_30_L       (REG_DISP_TOP_BASE + 0x60)
#define  REG_DISP_TOP_30_H       (REG_DISP_TOP_BASE + 0x61)
#define  REG_DISP_TOP_31_L       (REG_DISP_TOP_BASE + 0x62)
#define  REG_DISP_TOP_31_H       (REG_DISP_TOP_BASE + 0x63)
#define  REG_DISP_TOP_32_L       (REG_DISP_TOP_BASE + 0x64)
#define  REG_DISP_TOP_32_H       (REG_DISP_TOP_BASE + 0x65)
#define  REG_DISP_TOP_33_L       (REG_DISP_TOP_BASE + 0x66)
#define  REG_DISP_TOP_33_H       (REG_DISP_TOP_BASE + 0x67)
#define  REG_DISP_TOP_34_L       (REG_DISP_TOP_BASE + 0x68)
#define  REG_DISP_TOP_34_H       (REG_DISP_TOP_BASE + 0x69)
#define  REG_DISP_TOP_35_L       (REG_DISP_TOP_BASE + 0x6A)
#define  REG_DISP_TOP_35_H       (REG_DISP_TOP_BASE + 0x6B)
#define  REG_DISP_TOP_36_L       (REG_DISP_TOP_BASE + 0x6C)
#define  REG_DISP_TOP_36_H       (REG_DISP_TOP_BASE + 0x6D)
#define  REG_DISP_TOP_37_L       (REG_DISP_TOP_BASE + 0x6E)
#define  REG_DISP_TOP_37_H       (REG_DISP_TOP_BASE + 0x6F)
#define  REG_DISP_TOP_38_L       (REG_DISP_TOP_BASE + 0x70)
#define  REG_DISP_TOP_38_H       (REG_DISP_TOP_BASE + 0x71)
#define  REG_DISP_TOP_39_L       (REG_DISP_TOP_BASE + 0x72)
#define  REG_DISP_TOP_39_H       (REG_DISP_TOP_BASE + 0x73)
#define  REG_DISP_TOP_3A_L       (REG_DISP_TOP_BASE + 0x74)
#define  REG_DISP_TOP_3A_H       (REG_DISP_TOP_BASE + 0x75)
#define  REG_DISP_TOP_3B_L       (REG_DISP_TOP_BASE + 0x76)
#define  REG_DISP_TOP_3B_H       (REG_DISP_TOP_BASE + 0x77)
#define  REG_DISP_TOP_3C_L       (REG_DISP_TOP_BASE + 0x78)
#define  REG_DISP_TOP_3C_H       (REG_DISP_TOP_BASE + 0x79)
#define  REG_DISP_TOP_3D_L       (REG_DISP_TOP_BASE + 0x7A)
#define  REG_DISP_TOP_3D_H       (REG_DISP_TOP_BASE + 0x7B)
#define  REG_DISP_TOP_3E_L       (REG_DISP_TOP_BASE + 0x7C)
#define  REG_DISP_TOP_3E_H       (REG_DISP_TOP_BASE + 0x7D)
#define  REG_DISP_TOP_3F_L       (REG_DISP_TOP_BASE + 0x7E)
#define  REG_DISP_TOP_3F_H       (REG_DISP_TOP_BASE + 0x7F)
#define  REG_DISP_TOP_40_L       (REG_DISP_TOP_BASE + 0x80)
#define  REG_DISP_TOP_40_H       (REG_DISP_TOP_BASE + 0x81)
#define  REG_DISP_TOP_41_L       (REG_DISP_TOP_BASE + 0x82)
#define  REG_DISP_TOP_41_H       (REG_DISP_TOP_BASE + 0x83)
#define  REG_DISP_TOP_42_L       (REG_DISP_TOP_BASE + 0x84)
#define  REG_DISP_TOP_42_H       (REG_DISP_TOP_BASE + 0x85)
#define  REG_DISP_TOP_43_L       (REG_DISP_TOP_BASE + 0x86)
#define  REG_DISP_TOP_43_H       (REG_DISP_TOP_BASE + 0x87)
#define  REG_DISP_TOP_44_L       (REG_DISP_TOP_BASE + 0x88)
#define  REG_DISP_TOP_44_H       (REG_DISP_TOP_BASE + 0x89)
#define  REG_DISP_TOP_45_L       (REG_DISP_TOP_BASE + 0x8A)
#define  REG_DISP_TOP_45_H       (REG_DISP_TOP_BASE + 0x8B)
#define  REG_DISP_TOP_46_L       (REG_DISP_TOP_BASE + 0x8C)
#define  REG_DISP_TOP_46_H       (REG_DISP_TOP_BASE + 0x8D)
#define  REG_DISP_TOP_47_L       (REG_DISP_TOP_BASE + 0x8E)
#define  REG_DISP_TOP_47_H       (REG_DISP_TOP_BASE + 0x8F)
#define  REG_DISP_TOP_48_L       (REG_DISP_TOP_BASE + 0x90)
#define  REG_DISP_TOP_48_H       (REG_DISP_TOP_BASE + 0x91)
#define  REG_DISP_TOP_49_L       (REG_DISP_TOP_BASE + 0x92)
#define  REG_DISP_TOP_49_H       (REG_DISP_TOP_BASE + 0x93)
#define  REG_DISP_TOP_4A_L       (REG_DISP_TOP_BASE + 0x94)
#define  REG_DISP_TOP_4A_H       (REG_DISP_TOP_BASE + 0x95)
#define  REG_DISP_TOP_4B_L       (REG_DISP_TOP_BASE + 0x96)
#define  REG_DISP_TOP_4B_H       (REG_DISP_TOP_BASE + 0x97)
#define  REG_DISP_TOP_4C_L       (REG_DISP_TOP_BASE + 0x98)
#define  REG_DISP_TOP_4C_H       (REG_DISP_TOP_BASE + 0x99)
#define  REG_DISP_TOP_4D_L       (REG_DISP_TOP_BASE + 0x9A)
#define  REG_DISP_TOP_4D_H       (REG_DISP_TOP_BASE + 0x9B)
#define  REG_DISP_TOP_4E_L       (REG_DISP_TOP_BASE + 0x9C)
#define  REG_DISP_TOP_4E_H       (REG_DISP_TOP_BASE + 0x9D)
#define  REG_DISP_TOP_4F_L       (REG_DISP_TOP_BASE + 0x9E)
#define  REG_DISP_TOP_4F_H       (REG_DISP_TOP_BASE + 0x9F)
#define  REG_DISP_TOP_50_L       (REG_DISP_TOP_BASE + 0xA0)
#define  REG_DISP_TOP_50_H       (REG_DISP_TOP_BASE + 0xA1)
#define  REG_DISP_TOP_51_L       (REG_DISP_TOP_BASE + 0xA2)
#define  REG_DISP_TOP_51_H       (REG_DISP_TOP_BASE + 0xA3)
#define  REG_DISP_TOP_52_L       (REG_DISP_TOP_BASE + 0xA4)
#define  REG_DISP_TOP_52_H       (REG_DISP_TOP_BASE + 0xA5)
#define  REG_DISP_TOP_53_L       (REG_DISP_TOP_BASE + 0xA6)
#define  REG_DISP_TOP_53_H       (REG_DISP_TOP_BASE + 0xA7)
#define  REG_DISP_TOP_54_L       (REG_DISP_TOP_BASE + 0xA8)
#define  REG_DISP_TOP_54_H       (REG_DISP_TOP_BASE + 0xA9)
#define  REG_DISP_TOP_55_L       (REG_DISP_TOP_BASE + 0xAA)
#define  REG_DISP_TOP_55_H       (REG_DISP_TOP_BASE + 0xAB)
#define  REG_DISP_TOP_56_L       (REG_DISP_TOP_BASE + 0xAC)
#define  REG_DISP_TOP_56_H       (REG_DISP_TOP_BASE + 0xAD)
#define  REG_DISP_TOP_57_L       (REG_DISP_TOP_BASE + 0xAE)
#define  REG_DISP_TOP_57_H       (REG_DISP_TOP_BASE + 0xAF)
#define  REG_DISP_TOP_58_L       (REG_DISP_TOP_BASE + 0xB0)
#define  REG_DISP_TOP_58_H       (REG_DISP_TOP_BASE + 0xB1)
#define  REG_DISP_TOP_59_L       (REG_DISP_TOP_BASE + 0xB2)
#define  REG_DISP_TOP_59_H       (REG_DISP_TOP_BASE + 0xB3)
#define  REG_DISP_TOP_5A_L       (REG_DISP_TOP_BASE + 0xB4)
#define  REG_DISP_TOP_5A_H       (REG_DISP_TOP_BASE + 0xB5)
#define  REG_DISP_TOP_5B_L       (REG_DISP_TOP_BASE + 0xB6)
#define  REG_DISP_TOP_5B_H       (REG_DISP_TOP_BASE + 0xB7)
#define  REG_DISP_TOP_5C_L       (REG_DISP_TOP_BASE + 0xB8)
#define  REG_DISP_TOP_5C_H       (REG_DISP_TOP_BASE + 0xB9)
#define  REG_DISP_TOP_5D_L       (REG_DISP_TOP_BASE + 0xBA)
#define  REG_DISP_TOP_5D_H       (REG_DISP_TOP_BASE + 0xBB)
#define  REG_DISP_TOP_5E_L       (REG_DISP_TOP_BASE + 0xBC)
#define  REG_DISP_TOP_5E_H       (REG_DISP_TOP_BASE + 0xBD)
#define  REG_DISP_TOP_5F_L       (REG_DISP_TOP_BASE + 0xBE)
#define  REG_DISP_TOP_5F_H       (REG_DISP_TOP_BASE + 0xBF)
#define  REG_DISP_TOP_60_L       (REG_DISP_TOP_BASE + 0xC0)
#define  REG_DISP_TOP_60_H       (REG_DISP_TOP_BASE + 0xC1)
#define  REG_DISP_TOP_61_L       (REG_DISP_TOP_BASE + 0xC2)
#define  REG_DISP_TOP_61_H       (REG_DISP_TOP_BASE + 0xC3)
#define  REG_DISP_TOP_62_L       (REG_DISP_TOP_BASE + 0xC4)
#define  REG_DISP_TOP_62_H       (REG_DISP_TOP_BASE + 0xC5)
#define  REG_DISP_TOP_63_L       (REG_DISP_TOP_BASE + 0xC6)
#define  REG_DISP_TOP_63_H       (REG_DISP_TOP_BASE + 0xC7)
#define  REG_DISP_TOP_64_L       (REG_DISP_TOP_BASE + 0xC8)
#define  REG_DISP_TOP_64_H       (REG_DISP_TOP_BASE + 0xC9)
#define  REG_DISP_TOP_65_L       (REG_DISP_TOP_BASE + 0xCA)
#define  REG_DISP_TOP_65_H       (REG_DISP_TOP_BASE + 0xCB)
#define  REG_DISP_TOP_66_L       (REG_DISP_TOP_BASE + 0xCC)
#define  REG_DISP_TOP_66_H       (REG_DISP_TOP_BASE + 0xCD)
#define  REG_DISP_TOP_67_L       (REG_DISP_TOP_BASE + 0xCE)
#define  REG_DISP_TOP_67_H       (REG_DISP_TOP_BASE + 0xCF)
#define  REG_DISP_TOP_68_L       (REG_DISP_TOP_BASE + 0xD0)
#define  REG_DISP_TOP_68_H       (REG_DISP_TOP_BASE + 0xD1)
#define  REG_DISP_TOP_69_L       (REG_DISP_TOP_BASE + 0xD2)
#define  REG_DISP_TOP_69_H       (REG_DISP_TOP_BASE + 0xD3)
#define  REG_DISP_TOP_6A_L       (REG_DISP_TOP_BASE + 0xD4)
#define  REG_DISP_TOP_6A_H       (REG_DISP_TOP_BASE + 0xD5)
#define  REG_DISP_TOP_6B_L       (REG_DISP_TOP_BASE + 0xD6)
#define  REG_DISP_TOP_6B_H       (REG_DISP_TOP_BASE + 0xD7)
#define  REG_DISP_TOP_6C_L       (REG_DISP_TOP_BASE + 0xD8)
#define  REG_DISP_TOP_6C_H       (REG_DISP_TOP_BASE + 0xD9)
#define  REG_DISP_TOP_6D_L       (REG_DISP_TOP_BASE + 0xDA)
#define  REG_DISP_TOP_6D_H       (REG_DISP_TOP_BASE + 0xDB)
#define  REG_DISP_TOP_6E_L       (REG_DISP_TOP_BASE + 0xDC)
#define  REG_DISP_TOP_6E_H       (REG_DISP_TOP_BASE + 0xDD)
#define  REG_DISP_TOP_6F_L       (REG_DISP_TOP_BASE + 0xDE)
#define  REG_DISP_TOP_6F_H       (REG_DISP_TOP_BASE + 0xDF)
#define  REG_DISP_TOP_70_L       (REG_DISP_TOP_BASE + 0xE0)
#define  REG_DISP_TOP_70_H       (REG_DISP_TOP_BASE + 0xE1)
#define  REG_DISP_TOP_71_L       (REG_DISP_TOP_BASE + 0xE2)
#define  REG_DISP_TOP_71_H       (REG_DISP_TOP_BASE + 0xE3)
#define  REG_DISP_TOP_72_L       (REG_DISP_TOP_BASE + 0xE4)
#define  REG_DISP_TOP_72_H       (REG_DISP_TOP_BASE + 0xE5)
#define  REG_DISP_TOP_73_L       (REG_DISP_TOP_BASE + 0xE6)
#define  REG_DISP_TOP_73_H       (REG_DISP_TOP_BASE + 0xE7)
#define  REG_DISP_TOP_74_L       (REG_DISP_TOP_BASE + 0xE8)
#define  REG_DISP_TOP_74_H       (REG_DISP_TOP_BASE + 0xE9)
#define  REG_DISP_TOP_75_L       (REG_DISP_TOP_BASE + 0xEA)
#define  REG_DISP_TOP_75_H       (REG_DISP_TOP_BASE + 0xEB)
#define  REG_DISP_TOP_76_L       (REG_DISP_TOP_BASE + 0xEC)
#define  REG_DISP_TOP_76_H       (REG_DISP_TOP_BASE + 0xED)
#define  REG_DISP_TOP_77_L       (REG_DISP_TOP_BASE + 0xEE)
#define  REG_DISP_TOP_77_H       (REG_DISP_TOP_BASE + 0xEF)
#define  REG_DISP_TOP_78_L       (REG_DISP_TOP_BASE + 0xF0)
#define  REG_DISP_TOP_78_H       (REG_DISP_TOP_BASE + 0xF1)
#define  REG_DISP_TOP_79_L       (REG_DISP_TOP_BASE + 0xF2)
#define  REG_DISP_TOP_79_H       (REG_DISP_TOP_BASE + 0xF3)
#define  REG_DISP_TOP_7A_L       (REG_DISP_TOP_BASE + 0xF4)
#define  REG_DISP_TOP_7A_H       (REG_DISP_TOP_BASE + 0xF5)
#define  REG_DISP_TOP_7B_L       (REG_DISP_TOP_BASE + 0xF6)
#define  REG_DISP_TOP_7B_H       (REG_DISP_TOP_BASE + 0xF7)
#define  REG_DISP_TOP_7C_L       (REG_DISP_TOP_BASE + 0xF8)
#define  REG_DISP_TOP_7C_H       (REG_DISP_TOP_BASE + 0xF9)
#define  REG_DISP_TOP_7D_L       (REG_DISP_TOP_BASE + 0xFA)
#define  REG_DISP_TOP_7D_H       (REG_DISP_TOP_BASE + 0xFB)
#define  REG_DISP_TOP_7E_L       (REG_DISP_TOP_BASE + 0xFC)
#define  REG_DISP_TOP_7E_H       (REG_DISP_TOP_BASE + 0xFD)
#define  REG_DISP_TOP_7F_L       (REG_DISP_TOP_BASE + 0xFE)
#define  REG_DISP_TOP_7F_H       (REG_DISP_TOP_BASE + 0xFF)

#define  REG_SC_GP_CTRL_00_L       (REG_SC_GP_CTRL_BASE + 0x00)
#define  REG_SC_GP_CTRL_00_H       (REG_SC_GP_CTRL_BASE + 0x01)
#define  REG_SC_GP_CTRL_01_L       (REG_SC_GP_CTRL_BASE + 0x02)
#define  REG_SC_GP_CTRL_01_H       (REG_SC_GP_CTRL_BASE + 0x03)
#define  REG_SC_GP_CTRL_02_L       (REG_SC_GP_CTRL_BASE + 0x04)
#define  REG_SC_GP_CTRL_02_H       (REG_SC_GP_CTRL_BASE + 0x05)
#define  REG_SC_GP_CTRL_03_L       (REG_SC_GP_CTRL_BASE + 0x06)
#define  REG_SC_GP_CTRL_03_H       (REG_SC_GP_CTRL_BASE + 0x07)
#define  REG_SC_GP_CTRL_04_L       (REG_SC_GP_CTRL_BASE + 0x08)
#define  REG_SC_GP_CTRL_04_H       (REG_SC_GP_CTRL_BASE + 0x09)
#define  REG_SC_GP_CTRL_05_L       (REG_SC_GP_CTRL_BASE + 0x0A)
#define  REG_SC_GP_CTRL_05_H       (REG_SC_GP_CTRL_BASE + 0x0B)
#define  REG_SC_GP_CTRL_06_L       (REG_SC_GP_CTRL_BASE + 0x0C)
#define  REG_SC_GP_CTRL_06_H       (REG_SC_GP_CTRL_BASE + 0x0D)
#define  REG_SC_GP_CTRL_07_L       (REG_SC_GP_CTRL_BASE + 0x0E)
#define  REG_SC_GP_CTRL_07_H       (REG_SC_GP_CTRL_BASE + 0x0F)
#define  REG_SC_GP_CTRL_08_L       (REG_SC_GP_CTRL_BASE + 0x10)
#define  REG_SC_GP_CTRL_08_H       (REG_SC_GP_CTRL_BASE + 0x11)
#define  REG_SC_GP_CTRL_09_L       (REG_SC_GP_CTRL_BASE + 0x12)
#define  REG_SC_GP_CTRL_09_H       (REG_SC_GP_CTRL_BASE + 0x13)
#define  REG_SC_GP_CTRL_0A_L       (REG_SC_GP_CTRL_BASE + 0x14)
#define  REG_SC_GP_CTRL_0A_H       (REG_SC_GP_CTRL_BASE + 0x15)
#define  REG_SC_GP_CTRL_0B_L       (REG_SC_GP_CTRL_BASE + 0x16)
#define  REG_SC_GP_CTRL_0B_H       (REG_SC_GP_CTRL_BASE + 0x17)
#define  REG_SC_GP_CTRL_0C_L       (REG_SC_GP_CTRL_BASE + 0x18)
#define  REG_SC_GP_CTRL_0C_H       (REG_SC_GP_CTRL_BASE + 0x19)
#define  REG_SC_GP_CTRL_0D_L       (REG_SC_GP_CTRL_BASE + 0x1A)
#define  REG_SC_GP_CTRL_0D_H       (REG_SC_GP_CTRL_BASE + 0x1B)
#define  REG_SC_GP_CTRL_0E_L       (REG_SC_GP_CTRL_BASE + 0x1C)
#define  REG_SC_GP_CTRL_0E_H       (REG_SC_GP_CTRL_BASE + 0x1D)
#define  REG_SC_GP_CTRL_0F_L       (REG_SC_GP_CTRL_BASE + 0x1E)
#define  REG_SC_GP_CTRL_0F_H       (REG_SC_GP_CTRL_BASE + 0x1F)
#define  REG_SC_GP_CTRL_10_L       (REG_SC_GP_CTRL_BASE + 0x20)
#define  REG_SC_GP_CTRL_10_H       (REG_SC_GP_CTRL_BASE + 0x21)
#define  REG_SC_GP_CTRL_11_L       (REG_SC_GP_CTRL_BASE + 0x22)
#define  REG_SC_GP_CTRL_11_H       (REG_SC_GP_CTRL_BASE + 0x23)
#define  REG_SC_GP_CTRL_12_L       (REG_SC_GP_CTRL_BASE + 0x24)
#define  REG_SC_GP_CTRL_12_H       (REG_SC_GP_CTRL_BASE + 0x25)
#define  REG_SC_GP_CTRL_13_L       (REG_SC_GP_CTRL_BASE + 0x26)
#define  REG_SC_GP_CTRL_13_H       (REG_SC_GP_CTRL_BASE + 0x27)
#define  REG_SC_GP_CTRL_14_L       (REG_SC_GP_CTRL_BASE + 0x28)
#define  REG_SC_GP_CTRL_14_H       (REG_SC_GP_CTRL_BASE + 0x29)
#define  REG_SC_GP_CTRL_15_L       (REG_SC_GP_CTRL_BASE + 0x2A)
#define  REG_SC_GP_CTRL_15_H       (REG_SC_GP_CTRL_BASE + 0x2B)
#define  REG_SC_GP_CTRL_16_L       (REG_SC_GP_CTRL_BASE + 0x2C)
#define  REG_SC_GP_CTRL_16_H       (REG_SC_GP_CTRL_BASE + 0x2D)
#define  REG_SC_GP_CTRL_17_L       (REG_SC_GP_CTRL_BASE + 0x2E)
#define  REG_SC_GP_CTRL_17_H       (REG_SC_GP_CTRL_BASE + 0x2F)
#define  REG_SC_GP_CTRL_18_L       (REG_SC_GP_CTRL_BASE + 0x30)
#define  REG_SC_GP_CTRL_18_H       (REG_SC_GP_CTRL_BASE + 0x31)
#define  REG_SC_GP_CTRL_19_L       (REG_SC_GP_CTRL_BASE + 0x32)
#define  REG_SC_GP_CTRL_19_H       (REG_SC_GP_CTRL_BASE + 0x33)
#define  REG_SC_GP_CTRL_1A_L       (REG_SC_GP_CTRL_BASE + 0x34)
#define  REG_SC_GP_CTRL_1A_H       (REG_SC_GP_CTRL_BASE + 0x35)
#define  REG_SC_GP_CTRL_1B_L       (REG_SC_GP_CTRL_BASE + 0x36)
#define  REG_SC_GP_CTRL_1B_H       (REG_SC_GP_CTRL_BASE + 0x37)
#define  REG_SC_GP_CTRL_1C_L       (REG_SC_GP_CTRL_BASE + 0x38)
#define  REG_SC_GP_CTRL_1C_H       (REG_SC_GP_CTRL_BASE + 0x39)
#define  REG_SC_GP_CTRL_1D_L       (REG_SC_GP_CTRL_BASE + 0x3A)
#define  REG_SC_GP_CTRL_1D_H       (REG_SC_GP_CTRL_BASE + 0x3B)
#define  REG_SC_GP_CTRL_1E_L       (REG_SC_GP_CTRL_BASE + 0x3C)
#define  REG_SC_GP_CTRL_1E_H       (REG_SC_GP_CTRL_BASE + 0x3D)
#define  REG_SC_GP_CTRL_1F_L       (REG_SC_GP_CTRL_BASE + 0x3E)
#define  REG_SC_GP_CTRL_1F_H       (REG_SC_GP_CTRL_BASE + 0x3F)
#define  REG_SC_GP_CTRL_20_L       (REG_SC_GP_CTRL_BASE + 0x40)
#define  REG_SC_GP_CTRL_20_H       (REG_SC_GP_CTRL_BASE + 0x41)
#define  REG_SC_GP_CTRL_21_L       (REG_SC_GP_CTRL_BASE + 0x42)
#define  REG_SC_GP_CTRL_21_H       (REG_SC_GP_CTRL_BASE + 0x43)
#define  REG_SC_GP_CTRL_22_L       (REG_SC_GP_CTRL_BASE + 0x44)
#define  REG_SC_GP_CTRL_22_H       (REG_SC_GP_CTRL_BASE + 0x45)
#define  REG_SC_GP_CTRL_23_L       (REG_SC_GP_CTRL_BASE + 0x46)
#define  REG_SC_GP_CTRL_23_H       (REG_SC_GP_CTRL_BASE + 0x47)
#define  REG_SC_GP_CTRL_24_L       (REG_SC_GP_CTRL_BASE + 0x48)
#define  REG_SC_GP_CTRL_24_H       (REG_SC_GP_CTRL_BASE + 0x49)
#define  REG_SC_GP_CTRL_25_L       (REG_SC_GP_CTRL_BASE + 0x4A)
#define  REG_SC_GP_CTRL_25_H       (REG_SC_GP_CTRL_BASE + 0x4B)
#define  REG_SC_GP_CTRL_26_L       (REG_SC_GP_CTRL_BASE + 0x4C)
#define  REG_SC_GP_CTRL_26_H       (REG_SC_GP_CTRL_BASE + 0x4D)
#define  REG_SC_GP_CTRL_27_L       (REG_SC_GP_CTRL_BASE + 0x4E)
#define  REG_SC_GP_CTRL_27_H       (REG_SC_GP_CTRL_BASE + 0x4F)
#define  REG_SC_GP_CTRL_28_L       (REG_SC_GP_CTRL_BASE + 0x50)
#define  REG_SC_GP_CTRL_28_H       (REG_SC_GP_CTRL_BASE + 0x51)
#define  REG_SC_GP_CTRL_29_L       (REG_SC_GP_CTRL_BASE + 0x52)
#define  REG_SC_GP_CTRL_29_H       (REG_SC_GP_CTRL_BASE + 0x53)
#define  REG_SC_GP_CTRL_2A_L       (REG_SC_GP_CTRL_BASE + 0x54)
#define  REG_SC_GP_CTRL_2A_H       (REG_SC_GP_CTRL_BASE + 0x55)
#define  REG_SC_GP_CTRL_2B_L       (REG_SC_GP_CTRL_BASE + 0x56)
#define  REG_SC_GP_CTRL_2B_H       (REG_SC_GP_CTRL_BASE + 0x57)
#define  REG_SC_GP_CTRL_2C_L       (REG_SC_GP_CTRL_BASE + 0x58)
#define  REG_SC_GP_CTRL_2C_H       (REG_SC_GP_CTRL_BASE + 0x59)
#define  REG_SC_GP_CTRL_2D_L       (REG_SC_GP_CTRL_BASE + 0x5A)
#define  REG_SC_GP_CTRL_2D_H       (REG_SC_GP_CTRL_BASE + 0x5B)
#define  REG_SC_GP_CTRL_2E_L       (REG_SC_GP_CTRL_BASE + 0x5C)
#define  REG_SC_GP_CTRL_2E_H       (REG_SC_GP_CTRL_BASE + 0x5D)
#define  REG_SC_GP_CTRL_2F_L       (REG_SC_GP_CTRL_BASE + 0x5E)
#define  REG_SC_GP_CTRL_2F_H       (REG_SC_GP_CTRL_BASE + 0x5F)
#define  REG_SC_GP_CTRL_30_L       (REG_SC_GP_CTRL_BASE + 0x60)
#define  REG_SC_GP_CTRL_30_H       (REG_SC_GP_CTRL_BASE + 0x61)
#define  REG_SC_GP_CTRL_31_L       (REG_SC_GP_CTRL_BASE + 0x62)
#define  REG_SC_GP_CTRL_31_H       (REG_SC_GP_CTRL_BASE + 0x63)
#define  REG_SC_GP_CTRL_32_L       (REG_SC_GP_CTRL_BASE + 0x64)
#define  REG_SC_GP_CTRL_32_H       (REG_SC_GP_CTRL_BASE + 0x65)
#define  REG_SC_GP_CTRL_33_L       (REG_SC_GP_CTRL_BASE + 0x66)
#define  REG_SC_GP_CTRL_33_H       (REG_SC_GP_CTRL_BASE + 0x67)
#define  REG_SC_GP_CTRL_34_L       (REG_SC_GP_CTRL_BASE + 0x68)
#define  REG_SC_GP_CTRL_34_H       (REG_SC_GP_CTRL_BASE + 0x69)
#define  REG_SC_GP_CTRL_35_L       (REG_SC_GP_CTRL_BASE + 0x6A)
#define  REG_SC_GP_CTRL_35_H       (REG_SC_GP_CTRL_BASE + 0x6B)
#define  REG_SC_GP_CTRL_36_L       (REG_SC_GP_CTRL_BASE + 0x6C)
#define  REG_SC_GP_CTRL_36_H       (REG_SC_GP_CTRL_BASE + 0x6D)
#define  REG_SC_GP_CTRL_37_L       (REG_SC_GP_CTRL_BASE + 0x6E)
#define  REG_SC_GP_CTRL_37_H       (REG_SC_GP_CTRL_BASE + 0x6F)
#define  REG_SC_GP_CTRL_38_L       (REG_SC_GP_CTRL_BASE + 0x70)
#define  REG_SC_GP_CTRL_38_H       (REG_SC_GP_CTRL_BASE + 0x71)
#define  REG_SC_GP_CTRL_39_L       (REG_SC_GP_CTRL_BASE + 0x72)
#define  REG_SC_GP_CTRL_39_H       (REG_SC_GP_CTRL_BASE + 0x73)
#define  REG_SC_GP_CTRL_3A_L       (REG_SC_GP_CTRL_BASE + 0x74)
#define  REG_SC_GP_CTRL_3A_H       (REG_SC_GP_CTRL_BASE + 0x75)
#define  REG_SC_GP_CTRL_3B_L       (REG_SC_GP_CTRL_BASE + 0x76)
#define  REG_SC_GP_CTRL_3B_H       (REG_SC_GP_CTRL_BASE + 0x77)
#define  REG_SC_GP_CTRL_3C_L       (REG_SC_GP_CTRL_BASE + 0x78)
#define  REG_SC_GP_CTRL_3C_H       (REG_SC_GP_CTRL_BASE + 0x79)
#define  REG_SC_GP_CTRL_3D_L       (REG_SC_GP_CTRL_BASE + 0x7A)
#define  REG_SC_GP_CTRL_3D_H       (REG_SC_GP_CTRL_BASE + 0x7B)
#define  REG_SC_GP_CTRL_3E_L       (REG_SC_GP_CTRL_BASE + 0x7C)
#define  REG_SC_GP_CTRL_3E_H       (REG_SC_GP_CTRL_BASE + 0x7D)
#define  REG_SC_GP_CTRL_3F_L       (REG_SC_GP_CTRL_BASE + 0x7E)
#define  REG_SC_GP_CTRL_3F_H       (REG_SC_GP_CTRL_BASE + 0x7F)
#define  REG_SC_GP_CTRL_40_L       (REG_SC_GP_CTRL_BASE + 0x80)
#define  REG_SC_GP_CTRL_40_H       (REG_SC_GP_CTRL_BASE + 0x81)
#define  REG_SC_GP_CTRL_41_L       (REG_SC_GP_CTRL_BASE + 0x82)
#define  REG_SC_GP_CTRL_41_H       (REG_SC_GP_CTRL_BASE + 0x83)
#define  REG_SC_GP_CTRL_42_L       (REG_SC_GP_CTRL_BASE + 0x84)
#define  REG_SC_GP_CTRL_42_H       (REG_SC_GP_CTRL_BASE + 0x85)
#define  REG_SC_GP_CTRL_43_L       (REG_SC_GP_CTRL_BASE + 0x86)
#define  REG_SC_GP_CTRL_43_H       (REG_SC_GP_CTRL_BASE + 0x87)
#define  REG_SC_GP_CTRL_44_L       (REG_SC_GP_CTRL_BASE + 0x88)
#define  REG_SC_GP_CTRL_44_H       (REG_SC_GP_CTRL_BASE + 0x89)
#define  REG_SC_GP_CTRL_45_L       (REG_SC_GP_CTRL_BASE + 0x8A)
#define  REG_SC_GP_CTRL_45_H       (REG_SC_GP_CTRL_BASE + 0x8B)
#define  REG_SC_GP_CTRL_46_L       (REG_SC_GP_CTRL_BASE + 0x8C)
#define  REG_SC_GP_CTRL_46_H       (REG_SC_GP_CTRL_BASE + 0x8D)
#define  REG_SC_GP_CTRL_47_L       (REG_SC_GP_CTRL_BASE + 0x8E)
#define  REG_SC_GP_CTRL_47_H       (REG_SC_GP_CTRL_BASE + 0x8F)
#define  REG_SC_GP_CTRL_48_L       (REG_SC_GP_CTRL_BASE + 0x90)
#define  REG_SC_GP_CTRL_48_H       (REG_SC_GP_CTRL_BASE + 0x91)
#define  REG_SC_GP_CTRL_49_L       (REG_SC_GP_CTRL_BASE + 0x92)
#define  REG_SC_GP_CTRL_49_H       (REG_SC_GP_CTRL_BASE + 0x93)
#define  REG_SC_GP_CTRL_4A_L       (REG_SC_GP_CTRL_BASE + 0x94)
#define  REG_SC_GP_CTRL_4A_H       (REG_SC_GP_CTRL_BASE + 0x95)
#define  REG_SC_GP_CTRL_4B_L       (REG_SC_GP_CTRL_BASE + 0x96)
#define  REG_SC_GP_CTRL_4B_H       (REG_SC_GP_CTRL_BASE + 0x97)
#define  REG_SC_GP_CTRL_4C_L       (REG_SC_GP_CTRL_BASE + 0x98)
#define  REG_SC_GP_CTRL_4C_H       (REG_SC_GP_CTRL_BASE + 0x99)
#define  REG_SC_GP_CTRL_4D_L       (REG_SC_GP_CTRL_BASE + 0x9A)
#define  REG_SC_GP_CTRL_4D_H       (REG_SC_GP_CTRL_BASE + 0x9B)
#define  REG_SC_GP_CTRL_4E_L       (REG_SC_GP_CTRL_BASE + 0x9C)
#define  REG_SC_GP_CTRL_4E_H       (REG_SC_GP_CTRL_BASE + 0x9D)
#define  REG_SC_GP_CTRL_4F_L       (REG_SC_GP_CTRL_BASE + 0x9E)
#define  REG_SC_GP_CTRL_4F_H       (REG_SC_GP_CTRL_BASE + 0x9F)
#define  REG_SC_GP_CTRL_50_L       (REG_SC_GP_CTRL_BASE + 0xA0)
#define  REG_SC_GP_CTRL_50_H       (REG_SC_GP_CTRL_BASE + 0xA1)
#define  REG_SC_GP_CTRL_51_L       (REG_SC_GP_CTRL_BASE + 0xA2)
#define  REG_SC_GP_CTRL_51_H       (REG_SC_GP_CTRL_BASE + 0xA3)
#define  REG_SC_GP_CTRL_52_L       (REG_SC_GP_CTRL_BASE + 0xA4)
#define  REG_SC_GP_CTRL_52_H       (REG_SC_GP_CTRL_BASE + 0xA5)
#define  REG_SC_GP_CTRL_53_L       (REG_SC_GP_CTRL_BASE + 0xA6)
#define  REG_SC_GP_CTRL_53_H       (REG_SC_GP_CTRL_BASE + 0xA7)
#define  REG_SC_GP_CTRL_54_L       (REG_SC_GP_CTRL_BASE + 0xA8)
#define  REG_SC_GP_CTRL_54_H       (REG_SC_GP_CTRL_BASE + 0xA9)
#define  REG_SC_GP_CTRL_55_L       (REG_SC_GP_CTRL_BASE + 0xAA)
#define  REG_SC_GP_CTRL_55_H       (REG_SC_GP_CTRL_BASE + 0xAB)
#define  REG_SC_GP_CTRL_56_L       (REG_SC_GP_CTRL_BASE + 0xAC)
#define  REG_SC_GP_CTRL_56_H       (REG_SC_GP_CTRL_BASE + 0xAD)
#define  REG_SC_GP_CTRL_57_L       (REG_SC_GP_CTRL_BASE + 0xAE)
#define  REG_SC_GP_CTRL_57_H       (REG_SC_GP_CTRL_BASE + 0xAF)
#define  REG_SC_GP_CTRL_58_L       (REG_SC_GP_CTRL_BASE + 0xB0)
#define  REG_SC_GP_CTRL_58_H       (REG_SC_GP_CTRL_BASE + 0xB1)
#define  REG_SC_GP_CTRL_59_L       (REG_SC_GP_CTRL_BASE + 0xB2)
#define  REG_SC_GP_CTRL_59_H       (REG_SC_GP_CTRL_BASE + 0xB3)
#define  REG_SC_GP_CTRL_5A_L       (REG_SC_GP_CTRL_BASE + 0xB4)
#define  REG_SC_GP_CTRL_5A_H       (REG_SC_GP_CTRL_BASE + 0xB5)
#define  REG_SC_GP_CTRL_5B_L       (REG_SC_GP_CTRL_BASE + 0xB6)
#define  REG_SC_GP_CTRL_5B_H       (REG_SC_GP_CTRL_BASE + 0xB7)
#define  REG_SC_GP_CTRL_5C_L       (REG_SC_GP_CTRL_BASE + 0xB8)
#define  REG_SC_GP_CTRL_5C_H       (REG_SC_GP_CTRL_BASE + 0xB9)
#define  REG_SC_GP_CTRL_5D_L       (REG_SC_GP_CTRL_BASE + 0xBA)
#define  REG_SC_GP_CTRL_5D_H       (REG_SC_GP_CTRL_BASE + 0xBB)
#define  REG_SC_GP_CTRL_5E_L       (REG_SC_GP_CTRL_BASE + 0xBC)
#define  REG_SC_GP_CTRL_5E_H       (REG_SC_GP_CTRL_BASE + 0xBD)
#define  REG_SC_GP_CTRL_5F_L       (REG_SC_GP_CTRL_BASE + 0xBE)
#define  REG_SC_GP_CTRL_5F_H       (REG_SC_GP_CTRL_BASE + 0xBF)
#define  REG_SC_GP_CTRL_60_L       (REG_SC_GP_CTRL_BASE + 0xC0)
#define  REG_SC_GP_CTRL_60_H       (REG_SC_GP_CTRL_BASE + 0xC1)
#define  REG_SC_GP_CTRL_61_L       (REG_SC_GP_CTRL_BASE + 0xC2)
#define  REG_SC_GP_CTRL_61_H       (REG_SC_GP_CTRL_BASE + 0xC3)
#define  REG_SC_GP_CTRL_62_L       (REG_SC_GP_CTRL_BASE + 0xC4)
#define  REG_SC_GP_CTRL_62_H       (REG_SC_GP_CTRL_BASE + 0xC5)
#define  REG_SC_GP_CTRL_63_L       (REG_SC_GP_CTRL_BASE + 0xC6)
#define  REG_SC_GP_CTRL_63_H       (REG_SC_GP_CTRL_BASE + 0xC7)
#define  REG_SC_GP_CTRL_64_L       (REG_SC_GP_CTRL_BASE + 0xC8)
#define  REG_SC_GP_CTRL_64_H       (REG_SC_GP_CTRL_BASE + 0xC9)
#define  REG_SC_GP_CTRL_65_L       (REG_SC_GP_CTRL_BASE + 0xCA)
#define  REG_SC_GP_CTRL_65_H       (REG_SC_GP_CTRL_BASE + 0xCB)
#define  REG_SC_GP_CTRL_66_L       (REG_SC_GP_CTRL_BASE + 0xCC)
#define  REG_SC_GP_CTRL_66_H       (REG_SC_GP_CTRL_BASE + 0xCD)
#define  REG_SC_GP_CTRL_67_L       (REG_SC_GP_CTRL_BASE + 0xCE)
#define  REG_SC_GP_CTRL_67_H       (REG_SC_GP_CTRL_BASE + 0xCF)
#define  REG_SC_GP_CTRL_68_L       (REG_SC_GP_CTRL_BASE + 0xD0)
#define  REG_SC_GP_CTRL_68_H       (REG_SC_GP_CTRL_BASE + 0xD1)
#define  REG_SC_GP_CTRL_69_L       (REG_SC_GP_CTRL_BASE + 0xD2)
#define  REG_SC_GP_CTRL_69_H       (REG_SC_GP_CTRL_BASE + 0xD3)
#define  REG_SC_GP_CTRL_6A_L       (REG_SC_GP_CTRL_BASE + 0xD4)
#define  REG_SC_GP_CTRL_6A_H       (REG_SC_GP_CTRL_BASE + 0xD5)
#define  REG_SC_GP_CTRL_6B_L       (REG_SC_GP_CTRL_BASE + 0xD6)
#define  REG_SC_GP_CTRL_6B_H       (REG_SC_GP_CTRL_BASE + 0xD7)
#define  REG_SC_GP_CTRL_6C_L       (REG_SC_GP_CTRL_BASE + 0xD8)
#define  REG_SC_GP_CTRL_6C_H       (REG_SC_GP_CTRL_BASE + 0xD9)
#define  REG_SC_GP_CTRL_6D_L       (REG_SC_GP_CTRL_BASE + 0xDA)
#define  REG_SC_GP_CTRL_6D_H       (REG_SC_GP_CTRL_BASE + 0xDB)
#define  REG_SC_GP_CTRL_6E_L       (REG_SC_GP_CTRL_BASE + 0xDC)
#define  REG_SC_GP_CTRL_6E_H       (REG_SC_GP_CTRL_BASE + 0xDD)
#define  REG_SC_GP_CTRL_6F_L       (REG_SC_GP_CTRL_BASE + 0xDE)
#define  REG_SC_GP_CTRL_6F_H       (REG_SC_GP_CTRL_BASE + 0xDF)
#define  REG_SC_GP_CTRL_70_L       (REG_SC_GP_CTRL_BASE + 0xE0)
#define  REG_SC_GP_CTRL_70_H       (REG_SC_GP_CTRL_BASE + 0xE1)
#define  REG_SC_GP_CTRL_71_L       (REG_SC_GP_CTRL_BASE + 0xE2)
#define  REG_SC_GP_CTRL_71_H       (REG_SC_GP_CTRL_BASE + 0xE3)
#define  REG_SC_GP_CTRL_72_L       (REG_SC_GP_CTRL_BASE + 0xE4)
#define  REG_SC_GP_CTRL_72_H       (REG_SC_GP_CTRL_BASE + 0xE5)
#define  REG_SC_GP_CTRL_73_L       (REG_SC_GP_CTRL_BASE + 0xE6)
#define  REG_SC_GP_CTRL_73_H       (REG_SC_GP_CTRL_BASE + 0xE7)
#define  REG_SC_GP_CTRL_74_L       (REG_SC_GP_CTRL_BASE + 0xE8)
#define  REG_SC_GP_CTRL_74_H       (REG_SC_GP_CTRL_BASE + 0xE9)
#define  REG_SC_GP_CTRL_75_L       (REG_SC_GP_CTRL_BASE + 0xEA)
#define  REG_SC_GP_CTRL_75_H       (REG_SC_GP_CTRL_BASE + 0xEB)
#define  REG_SC_GP_CTRL_76_L       (REG_SC_GP_CTRL_BASE + 0xEC)
#define  REG_SC_GP_CTRL_76_H       (REG_SC_GP_CTRL_BASE + 0xED)
#define  REG_SC_GP_CTRL_77_L       (REG_SC_GP_CTRL_BASE + 0xEE)
#define  REG_SC_GP_CTRL_77_H       (REG_SC_GP_CTRL_BASE + 0xEF)
#define  REG_SC_GP_CTRL_78_L       (REG_SC_GP_CTRL_BASE + 0xF0)
#define  REG_SC_GP_CTRL_78_H       (REG_SC_GP_CTRL_BASE + 0xF1)
#define  REG_SC_GP_CTRL_79_L       (REG_SC_GP_CTRL_BASE + 0xF2)
#define  REG_SC_GP_CTRL_79_H       (REG_SC_GP_CTRL_BASE + 0xF3)
#define  REG_SC_GP_CTRL_7A_L       (REG_SC_GP_CTRL_BASE + 0xF4)
#define  REG_SC_GP_CTRL_7A_H       (REG_SC_GP_CTRL_BASE + 0xF5)
#define  REG_SC_GP_CTRL_7B_L       (REG_SC_GP_CTRL_BASE + 0xF6)
#define  REG_SC_GP_CTRL_7B_H       (REG_SC_GP_CTRL_BASE + 0xF7)
#define  REG_SC_GP_CTRL_7C_L       (REG_SC_GP_CTRL_BASE + 0xF8)
#define  REG_SC_GP_CTRL_7C_H       (REG_SC_GP_CTRL_BASE + 0xF9)
#define  REG_SC_GP_CTRL_7D_L       (REG_SC_GP_CTRL_BASE + 0xFA)
#define  REG_SC_GP_CTRL_7D_H       (REG_SC_GP_CTRL_BASE + 0xFB)
#define  REG_SC_GP_CTRL_7E_L       (REG_SC_GP_CTRL_BASE + 0xFC)
#define  REG_SC_GP_CTRL_7E_H       (REG_SC_GP_CTRL_BASE + 0xFD)
#define  REG_SC_GP_CTRL_7F_L       (REG_SC_GP_CTRL_BASE + 0xFE)
#define  REG_SC_GP_CTRL_7F_H       (REG_SC_GP_CTRL_BASE + 0xFF)

#define  REG_CLKGEN_00_L       (REG_CLKGEN_BASE + 0x00)
#define  REG_CLKGEN_00_H       (REG_CLKGEN_BASE + 0x01)
#define  REG_CLKGEN_01_L       (REG_CLKGEN_BASE + 0x02)
#define  REG_CLKGEN_01_H       (REG_CLKGEN_BASE + 0x03)
#define  REG_CLKGEN_02_L       (REG_CLKGEN_BASE + 0x04)
#define  REG_CLKGEN_02_H       (REG_CLKGEN_BASE + 0x05)
#define  REG_CLKGEN_03_L       (REG_CLKGEN_BASE + 0x06)
#define  REG_CLKGEN_03_H       (REG_CLKGEN_BASE + 0x07)
#define  REG_CLKGEN_04_L       (REG_CLKGEN_BASE + 0x08)
#define  REG_CLKGEN_04_H       (REG_CLKGEN_BASE + 0x09)
#define  REG_CLKGEN_05_L       (REG_CLKGEN_BASE + 0x0A)
#define  REG_CLKGEN_05_H       (REG_CLKGEN_BASE + 0x0B)
#define  REG_CLKGEN_06_L       (REG_CLKGEN_BASE + 0x0C)
#define  REG_CLKGEN_06_H       (REG_CLKGEN_BASE + 0x0D)
#define  REG_CLKGEN_07_L       (REG_CLKGEN_BASE + 0x0E)
#define  REG_CLKGEN_07_H       (REG_CLKGEN_BASE + 0x0F)
#define  REG_CLKGEN_08_L       (REG_CLKGEN_BASE + 0x10)
#define  REG_CLKGEN_08_H       (REG_CLKGEN_BASE + 0x11)
#define  REG_CLKGEN_09_L       (REG_CLKGEN_BASE + 0x12)
#define  REG_CLKGEN_09_H       (REG_CLKGEN_BASE + 0x13)
#define  REG_CLKGEN_0A_L       (REG_CLKGEN_BASE + 0x14)
#define  REG_CLKGEN_0A_H       (REG_CLKGEN_BASE + 0x15)
#define  REG_CLKGEN_0B_L       (REG_CLKGEN_BASE + 0x16)
#define  REG_CLKGEN_0B_H       (REG_CLKGEN_BASE + 0x17)
#define  REG_CLKGEN_0C_L       (REG_CLKGEN_BASE + 0x18)
#define  REG_CLKGEN_0C_H       (REG_CLKGEN_BASE + 0x19)
#define  REG_CLKGEN_0D_L       (REG_CLKGEN_BASE + 0x1A)
#define  REG_CLKGEN_0D_H       (REG_CLKGEN_BASE + 0x1B)
#define  REG_CLKGEN_0E_L       (REG_CLKGEN_BASE + 0x1C)
#define  REG_CLKGEN_0E_H       (REG_CLKGEN_BASE + 0x1D)
#define  REG_CLKGEN_0F_L       (REG_CLKGEN_BASE + 0x1E)
#define  REG_CLKGEN_0F_H       (REG_CLKGEN_BASE + 0x1F)
#define  REG_CLKGEN_10_L       (REG_CLKGEN_BASE + 0x20)
#define  REG_CLKGEN_10_H       (REG_CLKGEN_BASE + 0x21)
#define  REG_CLKGEN_11_L       (REG_CLKGEN_BASE + 0x22)
#define  REG_CLKGEN_11_H       (REG_CLKGEN_BASE + 0x23)
#define  REG_CLKGEN_12_L       (REG_CLKGEN_BASE + 0x24)
#define  REG_CLKGEN_12_H       (REG_CLKGEN_BASE + 0x25)
#define  REG_CLKGEN_13_L       (REG_CLKGEN_BASE + 0x26)
#define  REG_CLKGEN_13_H       (REG_CLKGEN_BASE + 0x27)
#define  REG_CLKGEN_14_L       (REG_CLKGEN_BASE + 0x28)
#define  REG_CLKGEN_14_H       (REG_CLKGEN_BASE + 0x29)
#define  REG_CLKGEN_15_L       (REG_CLKGEN_BASE + 0x2A)
#define  REG_CLKGEN_15_H       (REG_CLKGEN_BASE + 0x2B)
#define  REG_CLKGEN_16_L       (REG_CLKGEN_BASE + 0x2C)
#define  REG_CLKGEN_16_H       (REG_CLKGEN_BASE + 0x2D)
#define  REG_CLKGEN_17_L       (REG_CLKGEN_BASE + 0x2E)
#define  REG_CLKGEN_17_H       (REG_CLKGEN_BASE + 0x2F)
#define  REG_CLKGEN_18_L       (REG_CLKGEN_BASE + 0x30)
#define  REG_CLKGEN_18_H       (REG_CLKGEN_BASE + 0x31)
#define  REG_CLKGEN_19_L       (REG_CLKGEN_BASE + 0x32)
#define  REG_CLKGEN_19_H       (REG_CLKGEN_BASE + 0x33)
#define  REG_CLKGEN_1A_L       (REG_CLKGEN_BASE + 0x34)
#define  REG_CLKGEN_1A_H       (REG_CLKGEN_BASE + 0x35)
#define  REG_CLKGEN_1B_L       (REG_CLKGEN_BASE + 0x36)
#define  REG_CLKGEN_1B_H       (REG_CLKGEN_BASE + 0x37)
#define  REG_CLKGEN_1C_L       (REG_CLKGEN_BASE + 0x38)
#define  REG_CLKGEN_1C_H       (REG_CLKGEN_BASE + 0x39)
#define  REG_CLKGEN_1D_L       (REG_CLKGEN_BASE + 0x3A)
#define  REG_CLKGEN_1D_H       (REG_CLKGEN_BASE + 0x3B)
#define  REG_CLKGEN_1E_L       (REG_CLKGEN_BASE + 0x3C)
#define  REG_CLKGEN_1E_H       (REG_CLKGEN_BASE + 0x3D)
#define  REG_CLKGEN_1F_L       (REG_CLKGEN_BASE + 0x3E)
#define  REG_CLKGEN_1F_H       (REG_CLKGEN_BASE + 0x3F)
#define  REG_CLKGEN_20_L       (REG_CLKGEN_BASE + 0x40)
#define  REG_CLKGEN_20_H       (REG_CLKGEN_BASE + 0x41)
#define  REG_CLKGEN_21_L       (REG_CLKGEN_BASE + 0x42)
#define  REG_CLKGEN_21_H       (REG_CLKGEN_BASE + 0x43)
#define  REG_CLKGEN_22_L       (REG_CLKGEN_BASE + 0x44)
#define  REG_CLKGEN_22_H       (REG_CLKGEN_BASE + 0x45)
#define  REG_CLKGEN_23_L       (REG_CLKGEN_BASE + 0x46)
#define  REG_CLKGEN_23_H       (REG_CLKGEN_BASE + 0x47)
#define  REG_CLKGEN_24_L       (REG_CLKGEN_BASE + 0x48)
#define  REG_CLKGEN_24_H       (REG_CLKGEN_BASE + 0x49)
#define  REG_CLKGEN_25_L       (REG_CLKGEN_BASE + 0x4A)
#define  REG_CLKGEN_25_H       (REG_CLKGEN_BASE + 0x4B)
#define  REG_CLKGEN_26_L       (REG_CLKGEN_BASE + 0x4C)
#define  REG_CLKGEN_26_H       (REG_CLKGEN_BASE + 0x4D)
#define  REG_CLKGEN_27_L       (REG_CLKGEN_BASE + 0x4E)
#define  REG_CLKGEN_27_H       (REG_CLKGEN_BASE + 0x4F)
#define  REG_CLKGEN_28_L       (REG_CLKGEN_BASE + 0x50)
#define  REG_CLKGEN_28_H       (REG_CLKGEN_BASE + 0x51)
#define  REG_CLKGEN_29_L       (REG_CLKGEN_BASE + 0x52)
#define  REG_CLKGEN_29_H       (REG_CLKGEN_BASE + 0x53)
#define  REG_CLKGEN_2A_L       (REG_CLKGEN_BASE + 0x54)
#define  REG_CLKGEN_2A_H       (REG_CLKGEN_BASE + 0x55)
#define  REG_CLKGEN_2B_L       (REG_CLKGEN_BASE + 0x56)
#define  REG_CLKGEN_2B_H       (REG_CLKGEN_BASE + 0x57)
#define  REG_CLKGEN_2C_L       (REG_CLKGEN_BASE + 0x58)
#define  REG_CLKGEN_2C_H       (REG_CLKGEN_BASE + 0x59)
#define  REG_CLKGEN_2D_L       (REG_CLKGEN_BASE + 0x5A)
#define  REG_CLKGEN_2D_H       (REG_CLKGEN_BASE + 0x5B)
#define  REG_CLKGEN_2E_L       (REG_CLKGEN_BASE + 0x5C)
#define  REG_CLKGEN_2E_H       (REG_CLKGEN_BASE + 0x5D)
#define  REG_CLKGEN_2F_L       (REG_CLKGEN_BASE + 0x5E)
#define  REG_CLKGEN_2F_H       (REG_CLKGEN_BASE + 0x5F)
#define  REG_CLKGEN_30_L       (REG_CLKGEN_BASE + 0x60)
#define  REG_CLKGEN_30_H       (REG_CLKGEN_BASE + 0x61)
#define  REG_CLKGEN_31_L       (REG_CLKGEN_BASE + 0x62)
#define  REG_CLKGEN_31_H       (REG_CLKGEN_BASE + 0x63)
#define  REG_CLKGEN_32_L       (REG_CLKGEN_BASE + 0x64)
#define  REG_CLKGEN_32_H       (REG_CLKGEN_BASE + 0x65)
#define  REG_CLKGEN_33_L       (REG_CLKGEN_BASE + 0x66)
#define  REG_CLKGEN_33_H       (REG_CLKGEN_BASE + 0x67)
#define  REG_CLKGEN_34_L       (REG_CLKGEN_BASE + 0x68)
#define  REG_CLKGEN_34_H       (REG_CLKGEN_BASE + 0x69)
#define  REG_CLKGEN_35_L       (REG_CLKGEN_BASE + 0x6A)
#define  REG_CLKGEN_35_H       (REG_CLKGEN_BASE + 0x6B)
#define  REG_CLKGEN_36_L       (REG_CLKGEN_BASE + 0x6C)
#define  REG_CLKGEN_36_H       (REG_CLKGEN_BASE + 0x6D)
#define  REG_CLKGEN_37_L       (REG_CLKGEN_BASE + 0x6E)
#define  REG_CLKGEN_37_H       (REG_CLKGEN_BASE + 0x6F)
#define  REG_CLKGEN_38_L       (REG_CLKGEN_BASE + 0x70)
#define  REG_CLKGEN_38_H       (REG_CLKGEN_BASE + 0x71)
#define  REG_CLKGEN_39_L       (REG_CLKGEN_BASE + 0x72)
#define  REG_CLKGEN_39_H       (REG_CLKGEN_BASE + 0x73)
#define  REG_CLKGEN_3A_L       (REG_CLKGEN_BASE + 0x74)
#define  REG_CLKGEN_3A_H       (REG_CLKGEN_BASE + 0x75)
#define  REG_CLKGEN_3B_L       (REG_CLKGEN_BASE + 0x76)
#define  REG_CLKGEN_3B_H       (REG_CLKGEN_BASE + 0x77)
#define  REG_CLKGEN_3C_L       (REG_CLKGEN_BASE + 0x78)
#define  REG_CLKGEN_3C_H       (REG_CLKGEN_BASE + 0x79)
#define  REG_CLKGEN_3D_L       (REG_CLKGEN_BASE + 0x7A)
#define  REG_CLKGEN_3D_H       (REG_CLKGEN_BASE + 0x7B)
#define  REG_CLKGEN_3E_L       (REG_CLKGEN_BASE + 0x7C)
#define  REG_CLKGEN_3E_H       (REG_CLKGEN_BASE + 0x7D)
#define  REG_CLKGEN_3F_L       (REG_CLKGEN_BASE + 0x7E)
#define  REG_CLKGEN_3F_H       (REG_CLKGEN_BASE + 0x7F)
#define  REG_CLKGEN_40_L       (REG_CLKGEN_BASE + 0x80)
#define  REG_CLKGEN_40_H       (REG_CLKGEN_BASE + 0x81)
#define  REG_CLKGEN_41_L       (REG_CLKGEN_BASE + 0x82)
#define  REG_CLKGEN_41_H       (REG_CLKGEN_BASE + 0x83)
#define  REG_CLKGEN_42_L       (REG_CLKGEN_BASE + 0x84)
#define  REG_CLKGEN_42_H       (REG_CLKGEN_BASE + 0x85)
#define  REG_CLKGEN_43_L       (REG_CLKGEN_BASE + 0x86)
#define  REG_CLKGEN_43_H       (REG_CLKGEN_BASE + 0x87)
#define  REG_CLKGEN_44_L       (REG_CLKGEN_BASE + 0x88)
#define  REG_CLKGEN_44_H       (REG_CLKGEN_BASE + 0x89)
#define  REG_CLKGEN_45_L       (REG_CLKGEN_BASE + 0x8A)
#define  REG_CLKGEN_45_H       (REG_CLKGEN_BASE + 0x8B)
#define  REG_CLKGEN_46_L       (REG_CLKGEN_BASE + 0x8C)
#define  REG_CLKGEN_46_H       (REG_CLKGEN_BASE + 0x8D)
#define  REG_CLKGEN_47_L       (REG_CLKGEN_BASE + 0x8E)
#define  REG_CLKGEN_47_H       (REG_CLKGEN_BASE + 0x8F)
#define  REG_CLKGEN_48_L       (REG_CLKGEN_BASE + 0x90)
#define  REG_CLKGEN_48_H       (REG_CLKGEN_BASE + 0x91)
#define  REG_CLKGEN_49_L       (REG_CLKGEN_BASE + 0x92)
#define  REG_CLKGEN_49_H       (REG_CLKGEN_BASE + 0x93)
#define  REG_CLKGEN_4A_L       (REG_CLKGEN_BASE + 0x94)
#define  REG_CLKGEN_4A_H       (REG_CLKGEN_BASE + 0x95)
#define  REG_CLKGEN_4B_L       (REG_CLKGEN_BASE + 0x96)
#define  REG_CLKGEN_4B_H       (REG_CLKGEN_BASE + 0x97)
#define  REG_CLKGEN_4C_L       (REG_CLKGEN_BASE + 0x98)
#define  REG_CLKGEN_4C_H       (REG_CLKGEN_BASE + 0x99)
#define  REG_CLKGEN_4D_L       (REG_CLKGEN_BASE + 0x9A)
#define  REG_CLKGEN_4D_H       (REG_CLKGEN_BASE + 0x9B)
#define  REG_CLKGEN_4E_L       (REG_CLKGEN_BASE + 0x9C)
#define  REG_CLKGEN_4E_H       (REG_CLKGEN_BASE + 0x9D)
#define  REG_CLKGEN_4F_L       (REG_CLKGEN_BASE + 0x9E)
#define  REG_CLKGEN_4F_H       (REG_CLKGEN_BASE + 0x9F)
#define  REG_CLKGEN_50_L       (REG_CLKGEN_BASE + 0xA0)
#define  REG_CLKGEN_50_H       (REG_CLKGEN_BASE + 0xA1)
#define  REG_CLKGEN_51_L       (REG_CLKGEN_BASE + 0xA2)
#define  REG_CLKGEN_51_H       (REG_CLKGEN_BASE + 0xA3)
#define  REG_CLKGEN_52_L       (REG_CLKGEN_BASE + 0xA4)
#define  REG_CLKGEN_52_H       (REG_CLKGEN_BASE + 0xA5)
#define  REG_CLKGEN_53_L       (REG_CLKGEN_BASE + 0xA6)
#define  REG_CLKGEN_53_H       (REG_CLKGEN_BASE + 0xA7)
#define  REG_CLKGEN_54_L       (REG_CLKGEN_BASE + 0xA8)
#define  REG_CLKGEN_54_H       (REG_CLKGEN_BASE + 0xA9)
#define  REG_CLKGEN_55_L       (REG_CLKGEN_BASE + 0xAA)
#define  REG_CLKGEN_55_H       (REG_CLKGEN_BASE + 0xAB)
#define  REG_CLKGEN_56_L       (REG_CLKGEN_BASE + 0xAC)
#define  REG_CLKGEN_56_H       (REG_CLKGEN_BASE + 0xAD)
#define  REG_CLKGEN_57_L       (REG_CLKGEN_BASE + 0xAE)
#define  REG_CLKGEN_57_H       (REG_CLKGEN_BASE + 0xAF)
#define  REG_CLKGEN_58_L       (REG_CLKGEN_BASE + 0xB0)
#define  REG_CLKGEN_58_H       (REG_CLKGEN_BASE + 0xB1)
#define  REG_CLKGEN_59_L       (REG_CLKGEN_BASE + 0xB2)
#define  REG_CLKGEN_59_H       (REG_CLKGEN_BASE + 0xB3)
#define  REG_CLKGEN_5A_L       (REG_CLKGEN_BASE + 0xB4)
#define  REG_CLKGEN_5A_H       (REG_CLKGEN_BASE + 0xB5)
#define  REG_CLKGEN_5B_L       (REG_CLKGEN_BASE + 0xB6)
#define  REG_CLKGEN_5B_H       (REG_CLKGEN_BASE + 0xB7)
#define  REG_CLKGEN_5C_L       (REG_CLKGEN_BASE + 0xB8)
#define  REG_CLKGEN_5C_H       (REG_CLKGEN_BASE + 0xB9)
#define  REG_CLKGEN_5D_L       (REG_CLKGEN_BASE + 0xBA)
#define  REG_CLKGEN_5D_H       (REG_CLKGEN_BASE + 0xBB)
#define  REG_CLKGEN_5E_L       (REG_CLKGEN_BASE + 0xBC)
#define  REG_CLKGEN_5E_H       (REG_CLKGEN_BASE + 0xBD)
#define  REG_CLKGEN_5F_L       (REG_CLKGEN_BASE + 0xBE)
#define  REG_CLKGEN_5F_H       (REG_CLKGEN_BASE + 0xBF)
#define  REG_CLKGEN_60_L       (REG_CLKGEN_BASE + 0xC0)
#define  REG_CLKGEN_60_H       (REG_CLKGEN_BASE + 0xC1)
#define  REG_CLKGEN_61_L       (REG_CLKGEN_BASE + 0xC2)
#define  REG_CLKGEN_61_H       (REG_CLKGEN_BASE + 0xC3)
#define  REG_CLKGEN_62_L       (REG_CLKGEN_BASE + 0xC4)
#define  REG_CLKGEN_62_H       (REG_CLKGEN_BASE + 0xC5)
#define  REG_CLKGEN_63_L       (REG_CLKGEN_BASE + 0xC6)
#define  REG_CLKGEN_63_H       (REG_CLKGEN_BASE + 0xC7)
#define  REG_CLKGEN_64_L       (REG_CLKGEN_BASE + 0xC8)
#define  REG_CLKGEN_64_H       (REG_CLKGEN_BASE + 0xC9)
#define  REG_CLKGEN_65_L       (REG_CLKGEN_BASE + 0xCA)
#define  REG_CLKGEN_65_H       (REG_CLKGEN_BASE + 0xCB)
#define  REG_CLKGEN_66_L       (REG_CLKGEN_BASE + 0xCC)
#define  REG_CLKGEN_66_H       (REG_CLKGEN_BASE + 0xCD)
#define  REG_CLKGEN_67_L       (REG_CLKGEN_BASE + 0xCE)
#define  REG_CLKGEN_67_H       (REG_CLKGEN_BASE + 0xCF)
#define  REG_CLKGEN_68_L       (REG_CLKGEN_BASE + 0xD0)
#define  REG_CLKGEN_68_H       (REG_CLKGEN_BASE + 0xD1)
#define  REG_CLKGEN_69_L       (REG_CLKGEN_BASE + 0xD2)
#define  REG_CLKGEN_69_H       (REG_CLKGEN_BASE + 0xD3)
#define  REG_CLKGEN_6A_L       (REG_CLKGEN_BASE + 0xD4)
#define  REG_CLKGEN_6A_H       (REG_CLKGEN_BASE + 0xD5)
#define  REG_CLKGEN_6B_L       (REG_CLKGEN_BASE + 0xD6)
#define  REG_CLKGEN_6B_H       (REG_CLKGEN_BASE + 0xD7)
#define  REG_CLKGEN_6C_L       (REG_CLKGEN_BASE + 0xD8)
#define  REG_CLKGEN_6C_H       (REG_CLKGEN_BASE + 0xD9)
#define  REG_CLKGEN_6D_L       (REG_CLKGEN_BASE + 0xDA)
#define  REG_CLKGEN_6D_H       (REG_CLKGEN_BASE + 0xDB)
#define  REG_CLKGEN_6E_L       (REG_CLKGEN_BASE + 0xDC)
#define  REG_CLKGEN_6E_H       (REG_CLKGEN_BASE + 0xDD)
#define  REG_CLKGEN_6F_L       (REG_CLKGEN_BASE + 0xDE)
#define  REG_CLKGEN_6F_H       (REG_CLKGEN_BASE + 0xDF)
#define  REG_CLKGEN_70_L       (REG_CLKGEN_BASE + 0xE0)
#define  REG_CLKGEN_70_H       (REG_CLKGEN_BASE + 0xE1)
#define  REG_CLKGEN_71_L       (REG_CLKGEN_BASE + 0xE2)
#define  REG_CLKGEN_71_H       (REG_CLKGEN_BASE + 0xE3)
#define  REG_CLKGEN_72_L       (REG_CLKGEN_BASE + 0xE4)
#define  REG_CLKGEN_72_H       (REG_CLKGEN_BASE + 0xE5)
#define  REG_CLKGEN_73_L       (REG_CLKGEN_BASE + 0xE6)
#define  REG_CLKGEN_73_H       (REG_CLKGEN_BASE + 0xE7)
#define  REG_CLKGEN_74_L       (REG_CLKGEN_BASE + 0xE8)
#define  REG_CLKGEN_74_H       (REG_CLKGEN_BASE + 0xE9)
#define  REG_CLKGEN_75_L       (REG_CLKGEN_BASE + 0xEA)
#define  REG_CLKGEN_75_H       (REG_CLKGEN_BASE + 0xEB)
#define  REG_CLKGEN_76_L       (REG_CLKGEN_BASE + 0xEC)
#define  REG_CLKGEN_76_H       (REG_CLKGEN_BASE + 0xED)
#define  REG_CLKGEN_77_L       (REG_CLKGEN_BASE + 0xEE)
#define  REG_CLKGEN_77_H       (REG_CLKGEN_BASE + 0xEF)
#define  REG_CLKGEN_78_L       (REG_CLKGEN_BASE + 0xF0)
#define  REG_CLKGEN_78_H       (REG_CLKGEN_BASE + 0xF1)
#define  REG_CLKGEN_79_L       (REG_CLKGEN_BASE + 0xF2)
#define  REG_CLKGEN_79_H       (REG_CLKGEN_BASE + 0xF3)
#define  REG_CLKGEN_7A_L       (REG_CLKGEN_BASE + 0xF4)
#define  REG_CLKGEN_7A_H       (REG_CLKGEN_BASE + 0xF5)
#define  REG_CLKGEN_7B_L       (REG_CLKGEN_BASE + 0xF6)
#define  REG_CLKGEN_7B_H       (REG_CLKGEN_BASE + 0xF7)
#define  REG_CLKGEN_7C_L       (REG_CLKGEN_BASE + 0xF8)
#define  REG_CLKGEN_7C_H       (REG_CLKGEN_BASE + 0xF9)
#define  REG_CLKGEN_7D_L       (REG_CLKGEN_BASE + 0xFA)
#define  REG_CLKGEN_7D_H       (REG_CLKGEN_BASE + 0xFB)
#define  REG_CLKGEN_7E_L       (REG_CLKGEN_BASE + 0xFC)
#define  REG_CLKGEN_7E_H       (REG_CLKGEN_BASE + 0xFD)
#define  REG_CLKGEN_7F_L       (REG_CLKGEN_BASE + 0xFE)
#define  REG_CLKGEN_7F_H       (REG_CLKGEN_BASE + 0xFF)

#ifdef __cplusplus
}
#endif

#endif
